/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.JettyStatements;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.features.ImageApi;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.DeleteImageOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DockerComputeServiceLiveTest")
public class DockerComputeServiceLiveTest
extends BaseComputeServiceContextLiveTest {
    private static final String SSHABLE_IMAGE = "tutum/ubuntu";
    private static final String SSHABLE_IMAGE_TAG = "trusty";
    private Image defaultImage;
    protected Template template;
    protected Predicate<HostAndPort> socketTester;
    protected OpenSocketFinder openSocketFinder;
    protected ComputeService client;

    public DockerComputeServiceLiveTest() {
        this.provider = "docker";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    @BeforeGroups(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.buildSocketTester();
    }

    protected void initializeContext() {
        super.initializeContext();
        this.client = ((ComputeServiceContext)this.view).getComputeService();
        String imageName = "tutum/ubuntu:trusty";
        org.jclouds.docker.domain.Image image = this.imageApi().inspectImage(imageName);
        if (image == null) {
            CreateImageOptions options = CreateImageOptions.Builder.fromImage((String)SSHABLE_IMAGE).tag(SSHABLE_IMAGE_TAG);
            this.imageApi().createImage(options);
        }
        image = this.imageApi().inspectImage(imageName);
        this.defaultImage = this.client.getImage(image.id());
        Assert.assertNotNull((Object)this.defaultImage);
    }

    @AfterClass
    protected void tearDownContext() {
        super.tearDownContext();
        if (this.defaultImage != null) {
            this.imageApi().deleteImage("tutum/ubuntu:trusty", DeleteImageOptions.Builder.force((Boolean)true));
        }
    }

    private ImageApi imageApi() {
        return ((DockerApi)this.client.getContext().unwrapApi(DockerApi.class)).getImageApi();
    }

    protected Template buildTemplate(TemplateBuilder templateBuilder) {
        CreateImageOptions options;
        String imageName = "tutum/ubuntu:trusty";
        org.jclouds.docker.domain.Image image = this.imageApi().inspectImage(imageName);
        if (image == null) {
            options = CreateImageOptions.Builder.fromImage((String)SSHABLE_IMAGE).tag(SSHABLE_IMAGE_TAG);
            this.imageApi().createImage(options);
        }
        image = this.imageApi().inspectImage(imageName);
        this.defaultImage = this.client.getImage(image.id());
        options = new DockerTemplateOptions();
        options.env((List)ImmutableList.of((Object)"ROOT_PASS=password"));
        options.overrideLoginCredentials(LoginCredentials.builder().identity("root").credential("password").build());
        this.template = templateBuilder.imageId(this.defaultImage.getId()).options((TemplateOptions)options).build();
        return this.template;
    }

    protected void createAndRunAServiceInGroup(String group) throws RunNodesException {
        ImmutableMap userMetadata = ImmutableMap.of((Object)"test", (Object)group);
        ImmutableSet tags = ImmutableSet.of((Object)group);
        Stopwatch watch = Stopwatch.createStarted();
        this.template = this.buildTemplate(this.client.templateBuilder());
        this.template.getOptions().inboundPorts(new int[]{22, 8080}).blockOnPort(22, 300).userMetadata((Map)userMetadata).tags((Iterable)tags);
        NodeMetadata node = (NodeMetadata)Iterables.getOnlyElement((Iterable)this.client.createNodesInGroup(group, 1, this.template));
        long createSeconds = watch.elapsed(TimeUnit.SECONDS);
        String nodeId = node.getId();
        Logger.getAnonymousLogger().info(String.format("<< available node(%s) os(%s) in %ss", node.getId(), node.getOperatingSystem(), createSeconds));
        watch.reset().start();
        this.client.runScriptOnNode(nodeId, JettyStatements.install(), RunScriptOptions.Builder.nameTask((String)"configure-jetty"));
        long configureSeconds = watch.elapsed(TimeUnit.SECONDS);
        Logger.getAnonymousLogger().info(String.format("<< configured node(%s) with %s and jetty %s in %ss", nodeId, this.exec(nodeId, "java -fullversion"), this.exec(nodeId, JettyStatements.version()), configureSeconds));
        this.trackProcessOnNode(JettyStatements.start(), "start jetty", node);
        this.client.runScriptOnNode(nodeId, JettyStatements.stop(), (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false));
        this.trackProcessOnNode(JettyStatements.start(), "start jetty", node);
    }

    protected void trackProcessOnNode(Statement process, String processName, NodeMetadata node) {
        HostAndPort socket;
        ServiceStats stats = new ServiceStats();
        Stopwatch watch = Stopwatch.createStarted();
        ExecResponse exec = this.client.runScriptOnNode(node.getId(), process, (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false));
        stats.backgroundProcessMilliseconds = watch.elapsed(TimeUnit.MILLISECONDS);
        Container container = ((DockerApi)this.client.getContext().unwrapApi(DockerApi.class)).getContainerApi().inspectContainer(node.getId());
        Map ports = container.networkSettings().ports();
        int port = Integer.parseInt((String)((Map)Iterables.getOnlyElement((Iterable)((Iterable)ports.get("8080/tcp")))).get("HostPort"));
        watch.reset().start();
        try {
            socket = this.openSocketFinder.findOpenSocketOnNode(node, port, 600L, TimeUnit.SECONDS);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("%s%n%s%s", e.getMessage(), exec.getOutput(), exec.getError()));
        }
        stats.socketOpenMilliseconds = watch.elapsed(TimeUnit.MILLISECONDS);
        Logger.getAnonymousLogger().info(String.format("<< %s on node(%s)[%s] %s", processName, node.getId(), socket, stats));
    }

    protected String exec(String nodeId, String command) {
        return this.exec(nodeId, Statements.exec((String)command));
    }

    protected String exec(String nodeId, Statement command) {
        return this.client.runScriptOnNode(nodeId, command, (RunScriptOptions)TemplateOptions.Builder.runAsRoot((boolean)false).wrapInInitScript(false)).getOutput().trim();
    }

    protected void buildSocketTester() {
        SocketOpen socketOpen = (SocketOpen)((ComputeServiceContext)this.view).utils().injector().getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.openSocketFinder = (OpenSocketFinder)this.context.utils().injector().getInstance(OpenSocketFinder.class);
    }

    static class ServiceStats {
        long backgroundProcessMilliseconds;
        long socketOpenMilliseconds;

        ServiceStats() {
        }

        public String toString() {
            return String.format("[backgroundProcessMilliseconds=%s, socketOpenMilliseconds=%s]", this.backgroundProcessMilliseconds, this.socketOpenMilliseconds);
        }
    }
}

