/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.docker.DockerApi;
import org.jclouds.docker.compute.BaseDockerApiLiveTest;
import org.jclouds.docker.compute.options.DockerTemplateOptions;
import org.jclouds.docker.compute.strategy.DockerComputeServiceAdapter;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.DeleteImageOptions;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.AfterGroups;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DockerComputeServiceAdapterLiveTest")
public class DockerComputeServiceAdapterLiveTest
extends BaseDockerApiLiveTest {
    private static final String SSHABLE_IMAGE = "tutum/ubuntu";
    private static final String SSHABLE_IMAGE_TAG = "trusty";
    private Image defaultImage;
    private DockerComputeServiceAdapter adapter;
    private TemplateBuilder templateBuilder;
    private ComputeService computeService;
    private ComputeServiceAdapter.NodeAndInitialCredentials<Container> guest;

    @BeforeClass
    protected void init() {
        super.initialize();
        String imageName = "tutum/ubuntu:trusty";
        Image image = ((DockerApi)this.api).getImageApi().inspectImage(imageName);
        if (image == null) {
            CreateImageOptions options = CreateImageOptions.Builder.fromImage((String)SSHABLE_IMAGE).tag(SSHABLE_IMAGE_TAG);
            ((DockerApi)this.api).getImageApi().createImage(options);
        }
        this.defaultImage = ((DockerApi)this.api).getImageApi().inspectImage(imageName);
        Assert.assertNotNull((Object)this.defaultImage);
    }

    protected DockerApi create(Properties props, Iterable<Module> modules) {
        Injector injector = this.newBuilder().modules(modules).overrides(props).buildInjector();
        this.adapter = (DockerComputeServiceAdapter)injector.getInstance(DockerComputeServiceAdapter.class);
        this.templateBuilder = (TemplateBuilder)injector.getInstance(TemplateBuilder.class);
        this.computeService = (ComputeService)injector.getInstance(ComputeService.class);
        return (DockerApi)injector.getInstance(DockerApi.class);
    }

    public void testCreateNodeWithGroupEncodedIntoNameThenStoreCredentials() {
        String group = "foo";
        String name = "container" + new Random().nextInt();
        Template template = this.templateBuilder.imageId(this.defaultImage.id()).build();
        DockerTemplateOptions options = (DockerTemplateOptions)template.getOptions().as(DockerTemplateOptions.class);
        options.env((List)ImmutableList.of((Object)"ROOT_PASS=password"));
        this.guest = this.adapter.createNodeWithGroupEncodedIntoName(group, name, template);
        Assert.assertEquals((String)this.guest.getNodeId(), (String)((Container)this.guest.getNode()).id());
    }

    public void testListHardwareProfiles() {
        Iterable profiles = this.adapter.listHardwareProfiles();
        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)profiles));
        for (Hardware profile : profiles) {
            Assert.assertNotNull((Object)profile);
        }
    }

    @AfterGroups(groups={"live"})
    protected void tearDown() {
        if (this.guest != null) {
            this.adapter.destroyNode(((Container)this.guest.getNode()).id() + "");
        }
        if (this.defaultImage != null) {
            ((DockerApi)this.api).getImageApi().deleteImage(this.defaultImage.id(), DeleteImageOptions.Builder.force((Boolean)true));
        }
        super.tearDown();
    }

    @Override
    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)new SshjSshClientModule());
    }
}

