/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.exporter.TarExporter;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.docker.DockerApi;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.util.Closeables2;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseDockerApiLiveTest
extends BaseApiLiveTest<DockerApi> {
    public BaseDockerApiLiveTest() {
        this.provider = "docker";
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)new SshjSshClientModule());
    }

    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.trust-all-certs", "false");
        overrides.setProperty("jclouds.image.login-user", "root:password");
        return overrides;
    }

    protected String consumeStream(InputStream stream) {
        try {
            String string = CharStreams.toString((Readable)new InputStreamReader(stream, Charsets.UTF_8));
            return string;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            Closeables2.closeQuietly((Closeable)stream);
        }
    }

    public static Payload tarredDockerfile() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ((TarExporter)((GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)"archive.tar")).add((Asset)new ClassLoaderAsset("Dockerfile"), "Dockerfile")).as(TarExporter.class)).exportTo((OutputStream)bytes);
        return Payloads.newByteArrayPayload((byte[])bytes.toByteArray());
    }
}

