/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.elasticstack.functions.MapToStandardDrive;
import org.jclouds.elasticstack.suppliers.WellKnownImageSupplier;
import org.jclouds.util.Strings2;

@Singleton
public class MockStandardDiskImageSupplier
implements WellKnownImageSupplier {
    private final Function<StandardDrive, WellKnownImage> standardDriveToWellKnownImage;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToStandardDrive mapToStandardDrive;

    @Inject
    public MockStandardDiskImageSupplier(Function<StandardDrive, WellKnownImage> standardDriveToWellKnownImage, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToStandardDrive mapToStandardDrive) {
        this.standardDriveToWellKnownImage = (Function)Preconditions.checkNotNull(standardDriveToWellKnownImage, (Object)"standardDriveToWellKnownImage cannot be null");
        this.mapConverter = (ListOfKeyValuesDelimitedByBlankLinesToListOfMaps)Preconditions.checkNotNull((Object)mapConverter, (Object)"mapConverter cannot be null");
        this.mapToStandardDrive = (MapToStandardDrive)Preconditions.checkNotNull((Object)mapToStandardDrive, (Object)"mapToStandardDrive cannot be null");
    }

    public List<WellKnownImage> get() {
        try {
            String mockDrives = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/standard_drives.txt"));
            Iterable parsedDrives = Iterables.transform((Iterable)this.mapConverter.apply(mockDrives), (Function)this.mapToStandardDrive);
            return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)parsedDrives, this.standardDriveToWellKnownImage));
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

