/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import java.util.UUID;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.elasticstack.compute.functions.StandardDriveToWellKnownImage;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="StandardDriveToWellKnownImageTest")
public class StandardDriveToWellKnownImageTest {
    private StandardDriveToWellKnownImage function = new StandardDriveToWellKnownImage();

    public void testUnknownOperatingSystemParsing() {
        this.assertOS("Foo Linux 6.5", OsFamily.UNRECOGNIZED, "6.5", true);
    }

    public void testOperatingSystemWithoutVersionParsing() {
        this.assertOS("Ubuntu Linux", OsFamily.UBUNTU, null, true);
    }

    public void testKnownOperatingSystemParsing() {
        this.assertOS("centOS Linux 6.5", OsFamily.CENTOS, "6.5", true);
        this.assertOS("Debian Linux 7.4 (Wheezy)", OsFamily.DEBIAN, "7.4", true);
        this.assertOS("Ubuntu Linux 12.04.1 LTS (Precise Pangolin)", OsFamily.UBUNTU, "12.04.1", true);
        this.assertOS("Ubuntu Linux 13.10 (Saucy Salamander)", OsFamily.UBUNTU, "13.10", true);
        this.assertOS("Ubuntu 14.04 LTS (Trusty Tahr)", OsFamily.UBUNTU, "14.04", true);
        this.assertOS("Windows Server 2012", OsFamily.WINDOWS, "2012", true);
        this.assertOS("Windows Server 2012 + SQL", OsFamily.WINDOWS, "2012 + SQL", true);
        this.assertOS("Windows Server 2012 R2", OsFamily.WINDOWS, "2012 R2", true);
        this.assertOS("Windows Standard 2008 R2", OsFamily.WINDOWS, "2008 R2", true);
        this.assertOS("Windows Standard 2008 R2 + SQL", OsFamily.WINDOWS, "2008 R2 + SQL", true);
        this.assertOS("Windows Web Server 2008 R2", OsFamily.WINDOWS, "2008 R2", true);
        this.assertOS("Windows Web Server 2008 R2 + SQL", OsFamily.WINDOWS, "2008 R2 + SQL", true);
        this.assertOS("Ubuntu 10.10", OsFamily.UBUNTU, "10.10", true);
        this.assertOS("Debian 6.0.2.1", OsFamily.DEBIAN, "6.0.2.1", true);
        this.assertOS("Windows 2008 R2 (x64) with SP1", OsFamily.WINDOWS, "2008 R2 (x64) with SP1", true);
        this.assertOS("Windows 8 Developer Preview (x64)", OsFamily.WINDOWS, "8 Developer Preview (x64)", true);
        this.assertOS("CentOS Linux 5.5 64", OsFamily.CENTOS, "5.5", true);
        this.assertOS("CentOS Linux 5.6 64", OsFamily.CENTOS, "5.6", true);
        this.assertOS("CentOS Linux 5.7 64", OsFamily.CENTOS, "5.7", true);
        this.assertOS("Debian Linux 5.0", OsFamily.DEBIAN, "5.0", true);
        this.assertOS("Debian Linux 6 (Squeeze) 64", OsFamily.DEBIAN, "6", true);
        this.assertOS("Ubuntu 10.04.3 LTS (lucid) Server 64", OsFamily.UBUNTU, "10.04.3", true);
        this.assertOS("Windows 2008 R2 Standard Edition", OsFamily.WINDOWS, "2008 R2 Standard Edition", true);
        this.assertOS("CentOS 5.5 -32bit", OsFamily.CENTOS, "5.5", false);
        this.assertOS("CentOS 5.5 -64bit", OsFamily.CENTOS, "5.5", true);
        this.assertOS("CentOS 5.6 -32bit", OsFamily.CENTOS, "5.6", false);
        this.assertOS("CentOS 5.6 -64bit", OsFamily.CENTOS, "5.6", true);
        this.assertOS("Debian 5 -32bit", OsFamily.DEBIAN, "5", false);
        this.assertOS("Debian 5 -64bit", OsFamily.DEBIAN, "5", true);
        this.assertOS("Debian 6 -64bit -Experimental", OsFamily.DEBIAN, "6", true);
        this.assertOS("Ubuntu Server 10.04 -32bit", OsFamily.UBUNTU, "10.04", false);
        this.assertOS("Ubuntu Server 10.04 -64bit", OsFamily.UBUNTU, "10.04", true);
        this.assertOS("Ubuntu Server 10.10 -32bit", OsFamily.UBUNTU, "10.10", false);
        this.assertOS("Ubuntu Server 10.10 -64bit", OsFamily.UBUNTU, "10.10", true);
        this.assertOS("Windows 2008R2 Web Edition", OsFamily.WINDOWS, "2008R2 Web Edition", true);
        this.assertOS("Windows Server 2008R2 Standard", OsFamily.WINDOWS, "2008R2 Standard", true);
        this.assertOS("CentOS Linux 5.7", OsFamily.CENTOS, "5.7", true);
        this.assertOS("CentOS Linux 6.2", OsFamily.CENTOS, "6.2", true);
        this.assertOS("Debian Linux 6.0", OsFamily.DEBIAN, "6.0", true);
        this.assertOS("Ubuntu 10.04 LTS", OsFamily.UBUNTU, "10.04", true);
        this.assertOS("Ubuntu 12.04 LTS", OsFamily.UBUNTU, "12.04", true);
        this.assertOS("Windows Server 2008 R2 Standard", OsFamily.WINDOWS, "2008 R2 Standard", true);
        this.assertOS("Windows Server 2008 R2 Standard SP1 with SQL Server 2008 R2 Web Edition", OsFamily.WINDOWS, "2008 R2 Standard SP1 with SQL Server 2008 R2 Web Edition", true);
        this.assertOS("Windows Server 2012 Standard", OsFamily.WINDOWS, "2012 Standard", true);
        this.assertOS("Windows Web Server 2008 R2", OsFamily.WINDOWS, "2008 R2", true);
        this.assertOS("Windows Web Server 2008 R2 SP1 with SQL Server 2008 R2 Web Edition", OsFamily.WINDOWS, "2008 R2 SP1 with SQL Server 2008 R2 Web Edition", true);
    }

    private void assertOS(String name, OsFamily expectedFamily, String expectedVersion, boolean expectedIs64bit) {
        StandardDrive drive = StandardDriveToWellKnownImageTest.standardDrive(name);
        WellKnownImage image = this.function.apply(drive);
        Assert.assertEquals((Object)image.getOsFamily(), (Object)expectedFamily, (String)String.format("Parsing family for [%s]:", name));
        Assert.assertEquals((String)image.getOsVersion(), (String)expectedVersion, (String)String.format("Parsing version for [%s]:", name));
        Assert.assertEquals((boolean)image.is64bit(), (boolean)expectedIs64bit, (String)String.format("Parsing arch for [%s]:", name));
    }

    private static StandardDrive standardDrive(String name) {
        return new StandardDrive.Builder().uuid(UUID.randomUUID().toString()).size(1L).name(name).media(MediaType.DISK).build();
    }
}

