/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.handlers;

import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class ElasticStackErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var4_11;
        String message = this.parseMessage(response);
        HttpResponseException httpResponseException = message != null ? new HttpResponseException(command, response, message) : new HttpResponseException(command, response);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 400: {
                    if (command.getCurrentRequest().getEndpoint().getPath().endsWith("/info") || message != null && message.indexOf("could not be found") != -1) {
                        ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                        break;
                    }
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                    break;
                }
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(message, (Throwable)httpResponseException);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 405: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(message, (Throwable)httpResponseException);
                    break;
                }
                case 409: {
                    IllegalStateException illegalStateException = new IllegalStateException(message, (Throwable)httpResponseException);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                Closeables.close((Closeable)response.getPayload(), (boolean)true);
            }
            catch (IOException e) {
                // empty catch block
            }
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        try {
            Closeables.close((Closeable)response.getPayload(), (boolean)true);
        }
        catch (IOException e) {
            // empty catch block
        }
        command.setException((Exception)var4_11);
    }

    public String parseMessage(HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        try {
            String string = Strings2.toString((InputSupplier)response.getPayload());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }
}

