/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.MediaType;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.logging.Logger;

@Singleton
public class MapToStandardDrive
implements Function<Map<String, String>, StandardDrive> {
    @Resource
    protected Logger logger = Logger.NULL;

    public StandardDrive apply(Map<String, String> from) {
        if (from.isEmpty()) {
            return null;
        }
        StandardDrive.Builder builder = new StandardDrive.Builder();
        builder.name(from.get("name"));
        builder.media(MediaType.fromValue(from.get("media")));
        if (from.containsKey("tags")) {
            builder.tags(Splitter.on((char)' ').split((CharSequence)from.get("tags")));
        }
        builder.uuid(from.get("drive"));
        if (from.containsKey("claim:type")) {
            builder.claimType(ClaimType.fromValue(from.get("claim:type")));
        }
        if (from.containsKey("readers")) {
            builder.readers(Splitter.on((char)' ').split((CharSequence)from.get("readers")));
        }
        if (from.containsKey("size")) {
            builder.size(Long.valueOf(from.get("size")));
        }
        if (from.containsKey("rawsize")) {
            builder.rawSize(Long.valueOf(from.get("rawsize")));
        }
        if (from.containsKey("format")) {
            builder.format(ImageConversionType.fromValue(from.get("format")));
        }
        LinkedHashMap metadata = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : from.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("user:")) continue;
            metadata.put(key.substring(key.indexOf(58) + 1), entry.getValue());
        }
        builder.userMetadata((Map)metadata);
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            this.logger.trace("entry missing data: %s; %s", new Object[]{e.getMessage(), from});
            return null;
        }
    }
}

