/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.core.Username;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.events.GenericGroup;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.probe.MailboxProbe;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.EventDeadLettersProbe;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.probe.DataProbe;
import org.apache.james.server.core.MailImpl;
import org.apache.james.task.TaskManager;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.MailRepositoryProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.apache.james.webadmin.service.ClearMailboxContentTask;
import org.apache.mailet.Mail;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class RabbitMQWebAdminServerTaskSerializationIntegrationTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(CassandraRabbitMQJamesServerMain::createServer).build();
    private static final String DOMAIN = "domain";
    private static final String USERNAME = "username@domain";
    private DataProbe dataProbe;
    private MailboxProbe mailboxProbe;

    RabbitMQWebAdminServerTaskSerializationIntegrationTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        this.dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        this.dataProbe.addDomain(DOMAIN);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        this.mailboxProbe = (MailboxProbe)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    void recomputeFastViewProjectionItemsShouldComplete(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUser(USERNAME, "secret");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = (String)((Response)RestAssured.with().post("/mailboxes?task=recomputeFastViewProjectionItems", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"RecomputeAllFastViewProjectionItemsTask"), new Object[0])).body("additionalInformation.processedMessageCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.failedMessageCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void subscribeAllShouldComplete(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUser(USERNAME, "secret");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        String taskId = (String)((Response)RestAssured.with().post("/users/username@domain/mailboxes?task=subscribeAll", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"SubscribeAllTask"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.subscribedCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.unsubscribedCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void singleMailboxReindexingShouldComplete(GuiceJamesServer server) {
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox("#private", USERNAME, "INBOX");
        String taskId = (String)((Response)RestAssured.when().post("/mailboxes/" + mailboxId.serialize() + "?task=reIndex", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"mailbox-reindexing"), new Object[0])).body("additionalInformation.successfullyReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.mailboxId", Matchers.is((Object)mailboxId.serialize()), new Object[0])).body("additionalInformation.messageFailures", Matchers.is((Matcher)IsMapWithSize.anEmptyMap()), new Object[0]);
    }

    @Test
    void populateEmailQueryViewShouldComplete(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUser(USERNAME, "secret");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = (String)((Response)RestAssured.with().post("/mailboxes?task=populateEmailQueryView", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"PopulateEmailQueryViewTask"), new Object[0])).body("additionalInformation.processedMessageCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.failedMessageCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void deleteMailsFromMailQueueShouldCompleteWhenSenderIsValid() {
        String firstMailQueue = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/mailQueues").get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("[0]");
        String taskId = ((Response)RestAssured.with().basePath("/mailQueues").param("sender", new Object[]{USERNAME}).delete(firstMailQueue + "/mails", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"delete-mails-from-mail-queue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.sender", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.name", Matchers.is((Matcher)Matchers.nullValue()), new Object[0])).body("additionalInformation.recipient", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void reprocessingAllMailsShouldComplete() {
        String escapedRepositoryPath = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("mailRepositories").get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("[0].path");
        String taskId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("mailRepositories").param("action", new Object[]{"reprocess"}).patch(escapedRepositoryPath + "/mails", new Object[0])).then()).statusCode(201)).extract().jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"reprocessing-all"), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Matcher)Matchers.nullValue()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void reprocessingOneMailShouldCreateATask(GuiceJamesServer guiceJamesServer) throws Exception {
        MailRepositoryStore mailRepositoryStore = ((MailRepositoryProbeImpl)guiceJamesServer.getProbe(MailRepositoryProbeImpl.class)).getMailRepositoryStore();
        Stream urls = mailRepositoryStore.getUrls();
        MailRepositoryUrl mailRepositoryUrl = (MailRepositoryUrl)urls.findAny().get();
        MailRepository repository = (MailRepository)mailRepositoryStore.get(mailRepositoryUrl).get();
        String mailKey = "name1";
        repository.store((Mail)MailImpl.builder().name(mailKey).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().build()).build());
        String taskId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("mailRepositories").param("action", new Object[]{"reprocess"}).patch(mailRepositoryUrl.urlEncoded() + "/mails/name1", new Object[0])).then()).statusCode(201)).extract().jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"failed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"reprocessing-one"), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Object)mailRepositoryUrl.asString()), new Object[0])).body("additionalInformation.targetQueue", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.consume", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.mailKey", Matchers.is((Object)mailKey), new Object[0])).body("additionalInformation.targetProcessor", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void singleMessageReindexingShouldCompleteWhenMail() throws Exception {
        MailboxId mailboxId = this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        ComposedMessageId composedMessageId = this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = (String)((Response)RestAssured.with().post("/mailboxes/" + mailboxId.serialize() + "/mails/" + composedMessageId.getUid().asLong() + "?task=reIndex", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"message-reindexing"), new Object[0])).body("additionalInformation.mailboxId", Matchers.is((Object)mailboxId.serialize()), new Object[0])).body("additionalInformation.uid", Matchers.is((Object)Math.toIntExact(composedMessageId.getUid().asLong())), new Object[0]);
    }

    @Test
    void messageIdReIndexingShouldCompleteWhenMail() throws Exception {
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        ComposedMessageId composedMessageId = this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = (String)((Response)RestAssured.with().post("/messages/" + composedMessageId.getMessageId().serialize() + "?task=reIndex", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"messageId-reindexing"), new Object[0])).body("additionalInformation.messageId", Matchers.is((Object)composedMessageId.getMessageId().serialize()), new Object[0]);
    }

    @Test
    void userReindexingShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"reIndex"}).post("users/username@domain/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"user-reindexing"), new Object[0])).body("additionalInformation.successfullyReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.username", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.messageFailures", Matchers.is((Matcher)IsMapWithSize.anEmptyMap()), new Object[0]);
    }

    @Test
    void deletedMessageVaultRestoreShouldComplete() throws Exception {
        this.dataProbe.addUser(USERNAME, "password");
        String query = "{  \"fieldName\": \"subject\",  \"operator\": \"contains\",  \"value\": \"subject contains\"}";
        String taskId = (String)((Response)RestAssured.with().basePath("deletedMessages").queryParam("action", new Object[]{"restore"}).body(query).post("users/username@domain", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"deleted-messages-restore"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.successfulRestoreCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorRestoreCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void deletedMessageVaultExportShouldComplete() throws Exception {
        this.dataProbe.addUser(USERNAME, "password");
        String query = "{\"combinator\": \"and\",\"criteria\": []}";
        String exportTo = "exportTo@james.org";
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("deletedMessages").queryParam("action", new Object[]{"export"}).queryParam("exportTo", new Object[]{exportTo}).body(query).post("users/username@domain", new Object[0])).then()).statusCode(201)).extract().jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"deleted-messages-export"), new Object[0])).body("additionalInformation.userExportFrom", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.exportTo", Matchers.is((Object)exportTo), new Object[0])).body("additionalInformation.totalExportedMessages", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void errorRecoveryIndexationShouldCompleteWhenNoMail() {
        String taskId = (String)((Response)RestAssured.with().post("/mailboxes?task=reIndex", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        String fixingTaskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("reIndexFailedMessagesOf", new Object[]{taskId}).queryParam("task", new Object[]{"reIndex"}).post("/mailboxes", new Object[0])).then()).statusCode(201)).extract().jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(fixingTaskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"error-recovery-indexation"), new Object[0])).body("additionalInformation.successfullyReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.messageFailures", Matchers.is((Matcher)IsMapWithSize.anEmptyMap()), new Object[0]);
    }

    @Test
    void eventDeadLettersRedeliverShouldComplete() {
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("action", new Object[]{"reDeliver"}).post("/events/deadLetter", new Object[0])).then()).statusCode(201)).extract().jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"event-dead-letters-redeliver-all"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedRedeliveriesCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void eventDeadLettersRedeliverShouldCreateATask(GuiceJamesServer guiceJamesServer) {
        GenericGroup group = new GenericGroup("a");
        MailboxEvents.MailboxAdded event = this.createMailboxAdded();
        ((EventDeadLettersProbe)guiceJamesServer.getProbe(EventDeadLettersProbe.class)).getEventDeadLetters().store((Group)group, (Event)event).block();
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("action", new Object[]{"reDeliver"}).post("/events/deadLetter/groups/" + group.asString(), new Object[0])).then()).statusCode(201)).extract().jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"failed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"event-dead-letters-redeliver-group"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedRedeliveriesCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.group", Matchers.is((Object)group.asString()), new Object[0]);
    }

    @Test
    void postRedeliverSingleEventShouldCreateATask(GuiceJamesServer guiceJamesServer) {
        GenericGroup group = new GenericGroup("a");
        MailboxEvents.MailboxAdded event = this.createMailboxAdded();
        EventDeadLetters.InsertionId insertionId = (EventDeadLetters.InsertionId)((EventDeadLettersProbe)guiceJamesServer.getProbe(EventDeadLettersProbe.class)).getEventDeadLetters().store((Group)group, (Event)event).block();
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().queryParam("action", new Object[]{"reDeliver"}).post("/events/deadLetter/groups/" + group.asString() + "/" + insertionId.asString(), new Object[0])).then()).statusCode(201)).extract().jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"failed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"event-dead-letters-redeliver-one"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedRedeliveriesCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.group", Matchers.is((Object)group.asString()), new Object[0])).body("additionalInformation.insertionId", Matchers.is((Object)insertionId.asString()), new Object[0]);
    }

    @Test
    void mailboxMergingShouldComplete() {
        MailboxId origin = this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        MailboxId destination = this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX2");
        String taskId = ((Response)RestAssured.given().body("{    \"mergeOrigin\":\"" + origin.serialize() + "\",    \"mergeDestination\":\"" + destination.serialize() + "\"}").post("/cassandra/mailbox/merging", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"mailbox-merging"), new Object[0])).body("additionalInformation.oldMailboxId", Matchers.is((Object)origin.serialize()), new Object[0])).body("additionalInformation.newMailboxId", Matchers.is((Object)destination.serialize()), new Object[0])).body("additionalInformation.totalMessageCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.messageMovedCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.messageFailedCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void deletedMessagesVaultDeleteShouldCompleteEvenNoDeletedMessageExisted() throws Exception {
        this.dataProbe.addUser(USERNAME, "password");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        ComposedMessageId composedMessageId = this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = (String)((Response)RestAssured.with().basePath("deletedMessages").delete("users/username@domain/messages/" + composedMessageId.getMessageId().serialize(), new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"deleted-messages-delete"), new Object[0])).body("additionalInformation.username", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.deleteMessageId", Matchers.is((Object)composedMessageId.getMessageId().serialize()), new Object[0]);
    }

    @Test
    void deleteMailboxContentShouldComplete(GuiceJamesServer server) throws Exception {
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).addUser(USERNAME, "secret");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), (InputStream)new ByteArrayInputStream("Subject: test\r\n\r\ntestmail".getBytes()), new Date(), false, new Flags());
        String taskId = ((Response)RestAssured.given().delete("users/username@domain/mailboxes/INBOX/messages", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)ClearMailboxContentTask.TASK_TYPE.asString()), new Object[0])).body("additionalInformation.messagesSuccessCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.messagesFailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.username", Matchers.is((Object)USERNAME), new Object[0])).body("additionalInformation.mailboxName", Matchers.is((Object)"INBOX"), new Object[0]);
    }

    @Test
    void cleanUploadRepositoryShouldComplete() throws Exception {
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"expired"}).delete("jmap/uploads", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"UploadRepositoryCleanupTask"), new Object[0])).body("additionalInformation.scope", Matchers.is((Object)"expired"), new Object[0]);
    }

    @Test
    void blobGCTaskShouldComplete() {
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete("blobs", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.bloomFilterExpectedBlobCount", Matchers.is((Object)1000000), new Object[0])).body("additionalInformation.bloomFilterAssociatedProbability", Matchers.is((Object)Float.valueOf(0.01f)), new Object[0]);
    }

    private MailboxEvents.MailboxAdded createMailboxAdded() {
        String uuid = "6e0dd59d-660e-4d9b-b22f-0354479f47b4";
        return ((EventFactory.MailboxAddedFinalStage)((EventFactory.RequirePath)((EventFactory.RequireMailbox)((EventFactory.RequireSessionId)((EventFactory.RequireSession)EventFactory.mailboxAdded().eventId(Event.EventId.of((String)uuid))).user(Username.of((String)USERNAME))).sessionId(MailboxSession.SessionId.of((long)452L))).mailboxId((MailboxId)InMemoryId.of((long)453L))).mailboxPath(MailboxPath.forUser((Username)Username.of((String)USERNAME), (String)"Important-mailbox"))).build();
    }
}

