/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class RabbitMQWebAdminServerTaskSerializationIntegrationImmutableTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(CassandraRabbitMQJamesServerMain::createServer).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).build();
    private static final String DOMAIN = "domain";
    private static final String USERNAME = "username@domain";

    RabbitMQWebAdminServerTaskSerializationIntegrationImmutableTest() {
    }

    @BeforeAll
    static void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        DataProbe dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        dataProbe.addDomain(DOMAIN);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    void fullReindexingShouldCompleteWhenNoMail() {
        String taskId = (String)((Response)RestAssured.with().post("/mailboxes?task=reIndex", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"full-reindexing"), new Object[0])).body("additionalInformation.successfullyReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedReprocessedMailCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.messageFailures", Matchers.is((Matcher)IsMapWithSize.anEmptyMap()), new Object[0]);
    }

    @Test
    void clearMailQueueShouldCompleteWhenNoQueryParameters() {
        String firstMailQueue = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/mailQueues").get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("[0]");
        String taskId = ((Response)RestAssured.with().basePath("/mailQueues").delete(firstMailQueue + "/mails", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0])).body("type", Matchers.is((Object)"clear-mail-queue"), new Object[0])).body("additionalInformation.mailQueueName", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void blobStoreVaultGarbageCollectionShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().basePath("deletedMessages").queryParam("scope", new Object[]{"expired"}).delete()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"deleted-messages-blob-store-based-garbage-collection"), new Object[0])).body("additionalInformation.beginningOfRetentionPeriod", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.deletedBuckets", Matchers.is((Matcher)Matchers.empty()), new Object[0]);
    }

    @Test
    void clearMailRepositoryShouldComplete() {
        String escapedRepositoryPath = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("mailRepositories").get()).then()).statusCode(200)).contentType(ContentType.JSON)).extract().body().jsonPath().getString("[0].path");
        String taskId = (String)((Response)RestAssured.with().basePath("mailRepositories").delete(escapedRepositoryPath + "/mails", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"clear-mail-repository"), new Object[0])).body("additionalInformation.repositoryPath", Matchers.is((Matcher)CoreMatchers.notNullValue()), new Object[0])).body("additionalInformation.initialCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.remainingCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void cassandraMigrationShouldComplete() {
        SchemaVersion toVersion = CassandraSchemaVersionManager.MAX_VERSION;
        String taskId = (String)((Response)RestAssured.with().body(String.valueOf(toVersion.getValue())).post("cassandra/version/upgrade", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"cassandra-migration"), new Object[0])).body("additionalInformation.toVersion", Matchers.is((Object)toVersion.getValue()), new Object[0]);
    }

    @Test
    void cassandraMappingsSolveInconsistenciesShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().basePath("cassandra/mappings").queryParam("action", new Object[]{"SolveInconsistencies"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"cassandra-mappings-solve-inconsistencies"), new Object[0])).body("additionalInformation.successfulMappingsCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorMappingsCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void recomputeMailboxCountersShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().basePath("/mailboxes").queryParam("task", new Object[]{"RecomputeMailboxCounters"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"recompute-mailbox-counters"), new Object[0])).body("additionalInformation.processedMailboxes", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void recomputeCurrentQuotasShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().basePath("/quota/users").queryParam("task", new Object[]{"RecomputeCurrentQuotas"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"recompute-current-quotas"), new Object[0])).body("additionalInformation.processedQuotaRoots", Matchers.is((Object)0), new Object[0])).body("additionalInformation.failedQuotaRoots", Matchers.empty(), new Object[0]);
    }

    @Test
    void republishNotProcessedMailsOnSpoolShouldComplete() {
        String taskId = (String)((Response)RestAssured.with().basePath("/mailQueues/spool").queryParam("action", new Object[]{"RepublishNotProcessedMails"}).queryParam("olderThan", new Object[]{"2d"}).post()).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"republish-not-processed-mails"), new Object[0])).body("additionalInformation.nbRequeuedMails", Matchers.is((Object)0), new Object[0]);
    }
}

