/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.webadmin.integration.WebAdminServerIntegrationTest;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class RabbitMQWebAdminServerIntegrationTest
extends WebAdminServerIntegrationTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(CassandraRabbitMQJamesServerMain::createServer).build();
    private static final String VERSION = "/cassandra/version";
    private static final String VERSION_LATEST = "/cassandra/version/latest";
    private static final String UPGRADE_VERSION = "/cassandra/version/upgrade";
    private static final String UPGRADE_TO_LATEST_VERSION = "/cassandra/version/upgrade/latest";

    RabbitMQWebAdminServerIntegrationTest() {
    }

    @Test
    void getCurrentVersionShouldReturnNullForCurrentVersionAsBeginning() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)"{\"version\":null}"), new Matcher[0]);
    }

    @Test
    void postShouldDoMigrationAndUpdateCurrentVersion() {
        String taskId = (String)((Response)RestAssured.with().body(String.valueOf(CassandraSchemaVersionManager.MAX_VERSION.getValue())).post(UPGRADE_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        Awaitility.await().atMost(Durations.TEN_SECONDS).await().untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]));
    }

    @Test
    void postShouldDoMigrationAndUpdateToTheLatestVersion() {
        String taskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]);
    }

    @Test
    void cassandraMappingsEndpointShouldKeepDataConsistencyWhenDataValid() {
        RestAssured.with().put("address/aliases/username@domain/sources/alias1@domain", new Object[0]);
        RestAssured.with().put("address/aliases/username@domain/sources/alias2@domain", new Object[0]);
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"SolveInconsistencies"}).post("cassandra/mappings", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/aliases/username@domain", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{"alias1@domain", "alias2@domain"}), new Object[0]);
    }

    @Test
    void solveMailboxInconsistenciesTaskShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        taskId = (String)((Response)RestAssured.with().header("I-KNOW-WHAT-I-M-DOING", (Object)"ALL-SERVICES-ARE-OFFLINE", new Object[0]).queryParam("task", new Object[]{"SolveInconsistencies"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"solve-mailbox-inconsistencies"), new Object[0])).body("additionalInformation.processedMailboxEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.processedMailboxPathEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errors", Matchers.is((Object)0), new Object[0])).body("additionalInformation.fixedInconsistencies", Matchers.hasSize((int)0), new Object[0])).body("additionalInformation.conflictingEntries", Matchers.hasSize((int)0), new Object[0]);
    }
}

