/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.webadmin.integration.WebAdminServerIntegrationImmutableTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class RabbitMQWebAdminServerIntegrationImmutableTest
extends WebAdminServerIntegrationImmutableTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(CassandraRabbitMQJamesServerMain::createServer).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).build();
    private static final String VERSION = "/cassandra/version";
    private static final String VERSION_LATEST = "/cassandra/version/latest";
    private static final String UPGRADE_VERSION = "/cassandra/version/upgrade";
    private static final String UPGRADE_TO_LATEST_VERSION = "/cassandra/version/upgrade/latest";

    RabbitMQWebAdminServerIntegrationImmutableTest() {
    }

    @Test
    void getLatestVersionShouldReturnTheConfiguredLatestVersion() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get(VERSION_LATEST, new Object[0])).then()).statusCode(200)).contentType("application/json")).body(Matchers.is((Object)("{\"version\":" + CassandraSchemaVersionManager.MAX_VERSION.getValue() + "}")), new Matcher[0]);
    }

    @Test
    void solveMessageInconsistenciesTasksShouldBeExposed() {
        String taskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        taskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"SolveInconsistencies"}).post("/messages", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0])).body("type", Matchers.is((Object)"solve-message-inconsistencies"), new Object[0])).body("additionalInformation.processedImapUidEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.processedMessageIdEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.addedMessageIdEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.updatedMessageIdEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.removedMessageIdEntries", Matchers.is((Object)0), new Object[0])).body("additionalInformation.runningOptions.messagesPerSecond", Matchers.is((Object)100), new Object[0])).body("additionalInformation.fixedInconsistencies", Matchers.hasSize((int)0), new Object[0])).body("additionalInformation.errors", Matchers.hasSize((int)0), new Object[0]);
    }
}

