/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.probe.MailboxProbe;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.probe.DataProbe;
import org.apache.james.task.TaskManager;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.UpdatableTickingClock;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.RegisterExtension;

class RabbitMQWebAdminServerBlobGCIntegrationTest {
    private static final ZonedDateTime TIMESTAMP = ZonedDateTime.parse("2015-10-30T16:12:00Z");
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new ClockExtension()).server(CassandraRabbitMQJamesServerMain::createServer).build();
    private static final String DOMAIN = "domain";
    private static final String USERNAME = "username@domain";
    private DataProbe dataProbe;
    private MailboxProbe mailboxProbe;

    RabbitMQWebAdminServerBlobGCIntegrationTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer, UpdatableTickingClock clock) throws Exception {
        clock.setInstant(TIMESTAMP.toInstant());
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        this.dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        this.mailboxProbe = (MailboxProbe)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        this.dataProbe.addDomain(DOMAIN);
        this.dataProbe.addUser(USERNAME, "secret");
        this.mailboxProbe.createMailbox("#private", USERNAME, "INBOX");
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    @Test
    void blobGCShouldRemoveUnreferencedAndInactiveBlobId(UpdatableTickingClock clock) throws MailboxException {
        SharedByteArrayInputStream mailInputStream = ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/emailWithOnlyAttachment.eml");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), mailInputStream.newStream(0L, -1L), new Date(), false, new Flags());
        this.mailboxProbe.deleteMailbox("#private", USERNAME, "INBOX");
        clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete("blobs", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void blobGCShouldNotRemoveActiveBlobId() throws MailboxException {
        SharedByteArrayInputStream mailInputStream = ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/emailWithOnlyAttachment.eml");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), mailInputStream.newStream(0L, -1L), new Date(), false, new Flags());
        this.mailboxProbe.deleteMailbox("#private", USERNAME, "INBOX");
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete("blobs", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void blobGCShouldNotRemoveReferencedBlobId(UpdatableTickingClock clock) throws MailboxException {
        SharedByteArrayInputStream mailInputStream = ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/emailWithOnlyAttachment.eml");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), mailInputStream.newStream(0L, -1L), new Date(), false, new Flags());
        clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete("blobs", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
    }

    @Test
    void blobGCShouldNotRemoveReferencedBlobIdToAnotherMailbox(UpdatableTickingClock clock) throws Exception {
        SharedByteArrayInputStream mailInputStream = ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/emailWithOnlyAttachment.eml");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.inbox((Username)Username.of((String)USERNAME)), mailInputStream.newStream(0L, -1L), new Date(), false, new Flags());
        this.mailboxProbe.createMailbox("#private", USERNAME, "CustomBox");
        this.mailboxProbe.appendMessage(USERNAME, MailboxPath.forUser((Username)Username.of((String)USERNAME), (String)"CustomBox"), mailInputStream.newStream(0L, -1L), new Date(), false, new Flags());
        this.mailboxProbe.deleteMailbox("#private", USERNAME, "INBOX");
        clock.setInstant(TIMESTAMP.plusMonths(2L).toInstant());
        String taskId = ((Response)RestAssured.given().queryParam("scope", new Object[]{"unreferenced"}).delete("blobs", new Object[0])).jsonPath().getString("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("type", Matchers.is((Object)"BlobGCTask"), new Object[0])).body("additionalInformation.referenceSourceCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.blobCount", Matchers.is((Object)3), new Object[0])).body("additionalInformation.gcedBlobCount", Matchers.is((Object)0), new Object[0])).body("additionalInformation.errorCount", Matchers.is((Object)0), new Object[0]);
    }

    public static class ClockExtension
    implements GuiceModuleTestExtension {
        private UpdatableTickingClock clock;

        public void beforeEach(ExtensionContext extensionContext) {
            this.clock = new UpdatableTickingClock(TIMESTAMP.toInstant());
        }

        public Module getModule() {
            return binder -> binder.bind(Clock.class).toInstance((Object)this.clock);
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return parameterContext.getParameter().getType() == UpdatableTickingClock.class;
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.clock;
        }
    }
}

