/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.rabbitmq.DockerRabbitMQSingleton;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestRabbitMQModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.webadmin.integration.UnauthorizedEndpointsTest;
import org.apache.james.webadmin.integration.UnauthorizedModule;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="BasicFeature")
class RabbitMQUnauthorizedEndpointsTest
extends UnauthorizedEndpointsTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestRabbitMQModule(DockerRabbitMQSingleton.SINGLETON)}).overrideWith(new Module[]{new UnauthorizedModule()}).overrideWith(new Module[]{binder -> binder.bind(CleanupTasksPerformer.class).asEagerSingleton()})).lifeCycle(JamesServerExtension.Lifecycle.PER_CLASS).build();

    RabbitMQUnauthorizedEndpointsTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"/cassandra/version", "/cassandra/version/latest", "/dlp/rules/james.org", "/domainMappings", "/domainMappings/from.com", "/quota/domains/james.org", "/quota/domains/james.org/count", "/quota/domains/james.org/size", "/domains", "/users/someuser/mailboxes", "/users/someuser/mailboxes/mymailbox", "/quota/users", "/quota/users/joe@perdu.com", "/quota/users/joe@perdu.com/count", "/quota/users/joe@perdu.com/size", "/users", "address/forwards", "address/forwards/alice@james.org", "address/aliases", "address/aliases/bob@james.org", "/quota", "/quota/count", "/quota/size", "address/groups", "address/groups/group@james.org", "/mailQueues/first_queue", "mailRepositories", "mailRepositories/myRepo", "mailRepositories/myRepo/mails", "mailRepositories/myRepo/mails/1", "/sieve/quota/default", "/sieve/quota/users/user@james.org", "/tasks", "/tasks/taskId", "/tasks/taskId/await", "/events/deadLetter/groups", "/events/deadLetter/groups/group@james.org", "/events/deadLetter/groups/group@james.org/1"})
    public void checkUrlProtectionOnGet(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().get(url, new Object[0])).then()).statusCode(401);
    }

    @ParameterizedTest
    @ValueSource(strings={"/cassandra/version/upgrade", "/cassandra/version/upgrade/latest", "deletedMessages/joe@perdu.com", "cassandra/mappings", "/events/deadLetter", "/events/deadLetter/groups/group@james.org", "/events/deadLetter/groups/group@james.org/1"})
    public void checkUrlProtectionOnPost(String url) {
        ((ValidatableResponse)((Response)RestAssured.when().post(url, new Object[0])).then()).statusCode(401);
    }
}

