/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.time.Duration;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.core.Username;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.jmap.AccessToken;
import org.apache.james.jmap.HttpJmapAuthentication;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.jmap.JmapCommonRequests;
import org.apache.james.jmap.LocalHostURIBuilder;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class RabbitMQReindexingWithEventDeadLettersTest {
    private static final String ELASTICSEARCH_LISTENER_GROUP = "org.apache.james.mailbox.elasticsearch.v7.events.ElasticSearchListeningMessageSearchIndex$ElasticSearchListeningMessageSearchIndexGroup";
    private static final ConditionFactory CALMLY_AWAIT = Awaitility.with().pollInterval(Duration.ofMillis(100L)).and().pollDelay(Duration.ofMillis(100L)).atMost(Duration.ofMinutes(5L)).await();
    private static final DockerElasticSearchExtension dockerElasticSearch = new DockerElasticSearchExtension().withRequestTimeout(Duration.ofSeconds(5L));
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)dockerElasticSearch).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{binder -> binder.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.builder().maxRetries(2).firstBackoff(Duration.ofMillis(10L)).jitterFactor(0.2).build())})).build();
    private RequestSpecification webAdminApi;
    private AccessToken aliceAccessToken;

    RabbitMQReindexingWithEventDeadLettersTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer jamesServer) throws Exception {
        ((DataProbeImpl)jamesServer.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.tld").addUser(JMAPTestingConstants.ALICE.asString(), "789123");
        Port jmapPort = ((JmapGuiceProbe)jamesServer.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = JMAPTestingConstants.jmapRequestSpecBuilder.setPort(jmapPort.getValue()).build();
        RestAssured.defaultParser = Parser.JSON;
        this.webAdminApi = WebAdminUtils.spec((Port)((WebAdminGuiceProbe)jamesServer.getProbe(WebAdminGuiceProbe.class)).getWebAdminPort());
        this.aliceAccessToken = HttpJmapAuthentication.authenticateJamesUser((URIBuilder)LocalHostURIBuilder.baseUri((Port)jmapPort), (Username)JMAPTestingConstants.ALICE, (String)"789123");
        dockerElasticSearch.getDockerES().pause();
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
    }

    @Disabled(value="JAMES-3011 It's already fails for a long time, but CI didn't detect this when it's not marked as BasicFeature")
    @Test
    void indexationShouldBeFailingWhenElasticSearchContainerIsPaused() throws Exception {
        this.aliceSavesADraft();
        CALMLY_AWAIT.until(() -> this.listElasticSearchFailedEvents().size() == 1);
        this.unpauseElasticSearch();
        Assertions.assertThat((List)JmapCommonRequests.listMessageIdsForAccount((AccessToken)this.aliceAccessToken)).isEmpty();
    }

    @Test
    void redeliverShouldReIndexFailedMessagesAndCleanEventDeadLetter() throws Exception {
        this.aliceSavesADraft();
        CALMLY_AWAIT.until(() -> this.listElasticSearchFailedEvents().size() == 1);
        this.unpauseElasticSearch();
        this.redeliverAllFailedEvents();
        CALMLY_AWAIT.until(() -> JmapCommonRequests.listMessageIdsForAccount((AccessToken)this.aliceAccessToken).size() == 1);
        Assertions.assertThat(this.listElasticSearchFailedEvents()).isEmpty();
    }

    private void unpauseElasticSearch() throws Exception {
        dockerElasticSearch.getDockerES().unpause();
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
    }

    private void aliceSavesADraft() {
        String messageCreationId = "creationId1337";
        String requestBody = "[  [    \"setMessages\",    {      \"create\": { \"" + messageCreationId + "\" : {        \"from\": { \"name\": \"Me\", \"email\": \"" + JMAPTestingConstants.ALICE.asString() + "\"},        \"to\": [{ \"name\": \"BOB\", \"email\": \"someone@example.com\"}],        \"subject\": \"subject\",        \"keywords\": {\"$Draft\": true},        \"mailboxIds\": [\"" + JmapCommonRequests.getDraftId((AccessToken)this.aliceAccessToken) + "\"]      }}    },    \"#0\"  ]]";
        RestAssured.with().header("Authorization", (Object)this.aliceAccessToken.asString(), new Object[0]).body(requestBody).post("/jmap", new Object[0]);
    }

    private List<String> listElasticSearchFailedEvents() {
        return ((Response)((Response)this.webAdminApi.with().get("/events/deadLetter/groups/org.apache.james.mailbox.elasticsearch.v7.events.ElasticSearchListeningMessageSearchIndex$ElasticSearchListeningMessageSearchIndexGroup", new Object[0])).andReturn()).body().jsonPath().getList(".");
    }

    private void redeliverAllFailedEvents() {
        this.webAdminApi.with().queryParam("action", new Object[]{"reDeliver"}).post("/events/deadLetter", new Object[0]);
    }
}

