/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.rabbitmq.DockerRabbitMQ;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventDispatcher;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tags(value={@Tag(value="BasicFeature"), @Tag(value="unstable")})
class RabbitMQEventDeadLettersIntegrationTest {
    private static final int MAX_RETRIES = 2;
    private static RabbitMQExtension RABBIT_MQ_EXTENSION = new RabbitMQExtension();
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)RABBIT_MQ_EXTENSION).extension((GuiceModuleTestExtension)new RetryEventsListenerExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{binder -> binder.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.builder().maxRetries(2).firstBackoff(Duration.ofMillis(5L)).jitterFactor(0.2).build())})).build();
    private static final String DOMAIN = "domain.tld";
    private static final String BOB = "bob@domain.tld";
    private static final String BOB_PASSWORD = "bobPassword";
    private static final String EVENTS_ACTION = "reDeliver";
    private static final String GROUP_ID = new RetryEventsListenerGroup().asString();
    private static final String DISPATCHING_FAILURE_GROUP_ID = EventDispatcher.DispatchingFailureGroup.INSTANCE.getClass().getName();
    private static final MailboxPath BOB_INBOX_PATH = MailboxPath.inbox((Username)Username.of((String)"bob@domain.tld"));
    private Duration slowPacedPollInterval = Duration.ofMillis(100L);
    private ConditionFactory calmlyAwait = Awaitility.with().pollInterval(this.slowPacedPollInterval).and().with().pollDelay(this.slowPacedPollInterval).await();
    private ConditionFactory awaitAtMostTenSeconds = this.calmlyAwait.atMost(10L, TimeUnit.SECONDS);
    private MailboxProbeImpl mailboxProbe;

    RabbitMQEventDeadLettersIntegrationTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        DataProbe dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        this.mailboxProbe = (MailboxProbeImpl)guiceJamesServer.getProbe(MailboxProbeImpl.class);
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
        dataProbe.addDomain(DOMAIN);
        dataProbe.addUser(BOB, BOB_PASSWORD);
    }

    private MailboxId generateInitialEvent() {
        return this.mailboxProbe.createMailbox(BOB_INBOX_PATH);
    }

    private void generateSecondEvent() {
        this.mailboxProbe.createMailbox(MailboxPath.forUser((Username)Username.of((String)BOB), (String)"Outbox"));
    }

    private String retrieveFirstFailedInsertionId() {
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        return (String)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).jsonPath().getList(".").get(0);
    }

    @Test
    void failedEventShouldBeStoredInDeadLetterUnderItsGroupId(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]);
    }

    @Test
    void successfulEventShouldNotBeStoredInDeadLetter(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(1);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).until(() -> !retryEventsListener.successfulEvents.isEmpty());
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void groupIdOfFailedEventShouldBeStoredInDeadLetter(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.containsInAnyOrder((Object[])new String[]{GROUP_ID}), new Object[0]);
    }

    @Test
    void failedEventShouldBeStoredInDeadLetter(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        MailboxId mailboxId = this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("MailboxAdded.mailboxId", CoreMatchers.is((Object)mailboxId.serialize()), new Object[0])).body("MailboxAdded.user", CoreMatchers.is((Object)BOB), new Object[0])).body("MailboxAdded.mailboxPath.namespace", CoreMatchers.is((Object)BOB_INBOX_PATH.getNamespace()), new Object[0])).body("MailboxAdded.mailboxPath.user", CoreMatchers.is((Object)BOB_INBOX_PATH.getUser().asString()), new Object[0])).body("MailboxAdded.mailboxPath.name", CoreMatchers.is((Object)BOB_INBOX_PATH.getName()), new Object[0]);
    }

    @Test
    void multipleFailedEventShouldBeStoredInDeadLetter(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)2), new Object[0]);
    }

    @Test
    void failedEventShouldNotBeInDeadLetterAfterBeingDeleted(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        RestAssured.with().delete("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).then()).statusCode(404);
    }

    @Test
    void taskShouldBeCompletedAfterSuccessfulRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", CoreMatchers.is((Object)"completed"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", CoreMatchers.is((Object)1), new Object[0])).body("additionalInformation.failedRedeliveriesCount", CoreMatchers.is((Object)0), new Object[0])).body("additionalInformation.group", CoreMatchers.is((Object)GROUP_ID), new Object[0])).body("additionalInformation.insertionId", CoreMatchers.is((Object)failedInsertionId), new Object[0]);
    }

    @Test
    void failedEventShouldNotBeInDeadLettersAfterSuccessfulRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).then()).statusCode(404);
    }

    @Test
    void failedEventShouldBeCorrectlyProcessedByListenerAfterSuccessfulRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        this.awaitAtMostTenSeconds.until(() -> retryEventsListener.getSuccessfulEvents().size() == 1);
    }

    @Test
    void taskShouldBeCompletedAfterSuccessfulGroupRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", CoreMatchers.is((Object)"completed"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", CoreMatchers.is((Object)2), new Object[0])).body("additionalInformation.failedRedeliveriesCount", CoreMatchers.is((Object)0), new Object[0])).body("additionalInformation.group", CoreMatchers.is((Object)GROUP_ID), new Object[0]);
    }

    @Test
    void multipleFailedEventsShouldNotBeInDeadLettersAfterSuccessfulGroupRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void multipleFailedEventsShouldBeCorrectlyProcessedByListenerAfterSuccessfulGroupRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        this.awaitAtMostTenSeconds.until(() -> retryEventsListener.getSuccessfulEvents().size() == 2);
    }

    @Test
    void taskShouldBeCompletedAfterSuccessfulAllRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter", new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", CoreMatchers.is((Object)"completed"), new Object[0])).body("additionalInformation.successfulRedeliveriesCount", CoreMatchers.is((Object)2), new Object[0])).body("additionalInformation.failedRedeliveriesCount", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    void multipleFailedEventsShouldNotBeInDeadLettersAfterSuccessfulAllRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void multipleFailedEventsShouldBeCorrectlyProcessedByListenerAfterSuccessfulAllRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(3);
        this.generateInitialEvent();
        this.generateSecondEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)2), new Object[0]));
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        this.awaitAtMostTenSeconds.until(() -> retryEventsListener.getSuccessfulEvents().size() == 2);
    }

    @Disabled(value="retry rest API delivers only once, see JAMES-2907. We need same retry cound for this test to work")
    @Test
    void failedEventShouldStillBeInDeadLettersAfterFailedRedelivery(RetryEventsListener retryEventsListener) {
        retryEventsListener.callsPerEventBeforeSuccess(5);
        this.generateInitialEvent();
        this.calmlyAwait.atMost(Durations.ONE_MINUTE).untilAsserted(() -> ((ValidatableResponse)((Response)((Response)RestAssured.with().get("/events/deadLetter/groups/" + GROUP_ID, new Object[0])).prettyPeek()).then()).body(".", Matchers.hasSize((int)1), new Object[0]));
        String failedInsertionId = this.retrieveFirstFailedInsertionId();
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + GROUP_ID + "/" + failedInsertionId, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        String newFailedInsertionId = this.retrieveFirstFailedInsertionId();
        ((ValidatableResponse)((Response)RestAssured.when().get("/events/deadLetter/groups/" + GROUP_ID + "/" + newFailedInsertionId, new Object[0])).then()).statusCode(200);
    }

    @Test
    void failedDispatchingShouldBeRedeliveredToAllListeners(RetryEventsListener listener1, RetryEventsListener2 listener2, DockerRabbitMQ dockerRabbitMQ) {
        dockerRabbitMQ.pause();
        try {
            this.generateInitialEvent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dockerRabbitMQ.unpause();
        this.waitForFailedDispatching();
        this.waitForReDeliver(DISPATCHING_FAILURE_GROUP_ID);
        this.awaitAtMostTenSeconds.untilAsserted(() -> ((ListAssert)Assertions.assertThat(listener1.getSuccessfulEvents()).hasSameSizeAs(listener2.getSuccessfulEvents())).hasSize(1));
    }

    private void waitForReDeliver(String groupId) {
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{EVENTS_ACTION}).post("/events/deadLetter/groups/" + groupId, new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
    }

    private void waitForFailedDispatching() {
        this.calmlyAwait.untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/events/deadLetter/groups/" + DISPATCHING_FAILURE_GROUP_ID).get()).then()).statusCode(200)).contentType(ContentType.JSON)).body(".", Matchers.hasSize((int)1), new Object[0]));
    }

    public static class RetryEventsListener
    implements EventListener.GroupEventListener {
        static final Group GROUP = new RetryEventsListenerGroup();
        private final AtomicInteger totalCalls;
        private int callsBeforeSuccess = 0;
        private Map<Event.EventId, Integer> callsByEventId = new HashMap<Event.EventId, Integer>();
        private List<Event> successfulEvents = new ArrayList<Event>();

        RetryEventsListener() {
            this.totalCalls = new AtomicInteger(0);
        }

        public Group getDefaultGroup() {
            return GROUP;
        }

        public void event(Event event) {
            this.totalCalls.incrementAndGet();
            if (!this.done(event)) {
                this.increaseRetriesCount(event);
                throw new RuntimeException("throw to trigger retry");
            }
            this.callsByEventId.remove(event.getEventId());
            this.successfulEvents.add(event);
        }

        private void increaseRetriesCount(Event event) {
            this.callsByEventId.put(event.getEventId(), this.retriesCount(event) + 1);
        }

        int retriesCount(Event event) {
            return this.callsByEventId.getOrDefault(event.getEventId(), 0);
        }

        boolean done(Event event) {
            return this.retriesCount(event) >= this.callsBeforeSuccess;
        }

        List<Event> getSuccessfulEvents() {
            return this.successfulEvents;
        }

        void callsPerEventBeforeSuccess(int retriesBeforeSuccess) {
            this.callsBeforeSuccess = retriesBeforeSuccess;
        }
    }

    public static class RetryEventsListener2
    extends RetryEventsListener {
        static final Group GROUP = new RetryEventsListenerGroup2();

        @Override
        public Group getDefaultGroup() {
            return GROUP;
        }
    }

    public static class RetryEventsListenerExtension
    implements GuiceModuleTestExtension {
        private RetryEventsListener retryEventsListener;
        private RetryEventsListener2 retryEventsListener2;

        public void beforeEach(ExtensionContext extensionContext) {
            this.retryEventsListener = new RetryEventsListener();
            this.retryEventsListener2 = new RetryEventsListener2();
        }

        public Module getModule() {
            return binder -> {
                Multibinder setBinder = Multibinder.newSetBinder((Binder)binder, EventListener.GroupEventListener.class);
                setBinder.addBinding().toInstance((Object)this.retryEventsListener);
                setBinder.addBinding().toInstance((Object)this.retryEventsListener2);
            };
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            Class<?> paramType = parameterContext.getParameter().getType();
            return paramType == RetryEventsListener.class || paramType == RetryEventsListener2.class;
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            Class<?> paramType = parameterContext.getParameter().getType();
            if (paramType == RetryEventsListener.class) {
                return this.retryEventsListener;
            }
            if (paramType == RetryEventsListener2.class) {
                return this.retryEventsListener2;
            }
            throw new IllegalArgumentException("unsupported type");
        }
    }

    public static class RetryEventsListenerGroup
    extends Group {
    }

    public static class RetryEventsListenerGroup2
    extends Group {
    }
}

