/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import java.util.Optional;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.healthcheck.MailReceptionCheck;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class MailReceptionCheckIntegrationTest {
    private static final RabbitMQExtension RABBIT_MQ_EXTENSION = new RabbitMQExtension();
    public static final CassandraExtension CASSANDRA_EXTENSION = new CassandraExtension();
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)CASSANDRA_EXTENSION).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)RABBIT_MQ_EXTENSION).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{binder -> binder.bind(MailReceptionCheck.Configuration.class).toInstance((Object)new MailReceptionCheck.Configuration(Optional.of(JMAPTestingConstants.ALICE), Duration.ofSeconds(10L)))}).overrideWith(new Module[]{binder -> binder.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.builder().maxRetries(1).firstBackoff(Duration.ofMillis(2L)).jitterFactor(0.5).build())})).build();

    MailReceptionCheckIntegrationTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        ((DataProbeImpl)guiceJamesServer.getProbe(DataProbeImpl.class)).fluent().addDomain("domain.tld").addUser(JMAPTestingConstants.ALICE.asString(), "789123");
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void shouldBeHealthy() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)"MailReceptionCheck").when().get("/healthcheck/checks/{componentName}", new Object[0])).then()).body("componentName", Matchers.equalTo((Object)"MailReceptionCheck"), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)"MailReceptionCheck"), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.HEALTHY.getValue()), new Object[0])).body("cause", Matchers.is((Matcher)Matchers.nullValue()), new Object[0]);
    }

    @Test
    void shouldBeUnhealthyWhenRabbitMQIsPaused() throws Exception {
        RABBIT_MQ_EXTENSION.dockerRabbitMQ().pause();
        Thread.sleep(1000L);
        try {
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().pathParam("componentName", (Object)"MailReceptionCheck").when().get("/healthcheck/checks/{componentName}", new Object[0])).then()).body("componentName", Matchers.equalTo((Object)"MailReceptionCheck"), new Object[0])).body("escapedComponentName", Matchers.equalTo((Object)"MailReceptionCheck"), new Object[0])).body("status", Matchers.equalTo((Object)ResultStatus.UNHEALTHY.getValue()), new Object[0]);
        }
        finally {
            RABBIT_MQ_EXTENSION.dockerRabbitMQ().unpause();
        }
    }
}

