/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.inject.Module;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.http.client.utils.URIBuilder;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.init.ClusterFactory;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQFixture;
import org.apache.james.core.Username;
import org.apache.james.jmap.AccessToken;
import org.apache.james.jmap.HttpJmapAuthentication;
import org.apache.james.jmap.LocalHostURIBuilder;
import org.apache.james.jmap.draft.JmapGuiceProbe;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.probe.ACLProbe;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.TestJMAPServerModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.server.CassandraProbe;
import org.apache.james.task.TaskManager;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class FixingGhostMailboxTest {
    private static final String NAME = "[0][0]";
    private static final String ARGUMENTS = "[0][1]";
    private static final String FIRST_MAILBOX = "[0][1].list[0]";
    private static final String DOMAIN = "domain.tld";
    private static final String CEDRIC = "cedric@domain.tld";
    private static final String BOB = "bob@domain.tld";
    private static final String ALICE = "alice@domain.tld";
    private static final String ALICE_SECRET = "aliceSecret";
    private static final String BOB_SECRET = "bobSecret";
    private static final Duration THIRTY_SECONDS = Duration.ofSeconds(30L);
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{new TestJMAPServerModule()}).overrideWith(new Module[]{binder -> binder.bind(CassandraConfiguration.class).toInstance((Object)CassandraConfiguration.builder().mailboxReadRepair(0.0f).mailboxCountersReadRepairMax(0.0f).mailboxCountersReadRepairChanceOneHundred(0.0f).build())})).build();
    private AccessToken accessToken;
    private MailboxProbeImpl mailboxProbe;
    private ACLProbe aclProbe;
    private ComposedMessageId message1;
    private MailboxId aliceGhostInboxId;
    private MailboxPath aliceInboxPath;
    private ComposedMessageId message2;
    private RequestSpecification webadminSpecification;

    FixingGhostMailboxTest() {
    }

    @BeforeEach
    void setup(GuiceJamesServer server) throws Throwable {
        WebAdminGuiceProbe webAdminProbe = (WebAdminGuiceProbe)server.getProbe(WebAdminGuiceProbe.class);
        this.mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        this.aclProbe = (ACLProbe)server.getProbe(ACLProbeImpl.class);
        Port jmapPort = ((JmapGuiceProbe)server.getProbe(JmapGuiceProbe.class)).getJmapPort();
        RestAssured.requestSpecification = new RequestSpecBuilder().setContentType(ContentType.JSON).setAccept(ContentType.JSON).setConfig(RestAssuredConfig.newConfig().encoderConfig(EncoderConfig.encoderConfig().defaultContentCharset(StandardCharsets.UTF_8))).setPort(jmapPort.getValue()).build();
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        this.webadminSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminProbe.getWebAdminPort()).build();
        ((DataProbeImpl)server.getProbe(DataProbeImpl.class)).fluent().addDomain(DOMAIN).addUser(ALICE, ALICE_SECRET).addUser(BOB, BOB_SECRET);
        this.accessToken = HttpJmapAuthentication.authenticateJamesUser((URIBuilder)LocalHostURIBuilder.baseUri((Port)jmapPort), (Username)Username.of((String)ALICE), (String)ALICE_SECRET);
        CassandraProbe probe = (CassandraProbe)server.getProbe(CassandraProbe.class);
        ClusterConfiguration cassandraConfiguration = probe.getConfiguration();
        try (Cluster cluster = ClusterFactory.create((ClusterConfiguration)cassandraConfiguration, (CassandraConsistenciesConfiguration)CassandraConsistenciesConfiguration.DEFAULT);
             Session session = cluster.connect(probe.getMainKeyspaceConfiguration().getKeyspace());){
            this.simulateGhostMailboxBug(session);
        }
    }

    private void simulateGhostMailboxBug(Session session) throws MailboxException, IOException {
        this.aliceInboxPath = MailboxPath.inbox((Username)Username.of((String)ALICE));
        this.aliceGhostInboxId = this.mailboxProbe.createMailbox("#private", ALICE, "INBOX");
        this.aclProbe.addRights(this.aliceInboxPath, BOB, MailboxACL.FULL_RIGHTS);
        this.message1 = this.mailboxProbe.appendMessage(ALICE, this.aliceInboxPath, MessageManager.AppendCommand.from((Message)this.generateMessageContent()));
        testExtension.await();
        session.execute((Statement)QueryBuilder.delete().from("mailboxPathV3").where(QueryBuilder.eq((String)"namespace", (Object)"#private")).and(QueryBuilder.eq((String)"user", (Object)ALICE)).and(QueryBuilder.eq((String)"mailboxName", (Object)"INBOX")));
        ((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)this.accessToken.asString(), new Object[0]).body("[[\"getMailboxes\", {}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200);
        this.message2 = this.mailboxProbe.appendMessage(ALICE, this.aliceInboxPath, MessageManager.AppendCommand.from((Message)this.generateMessageContent()));
        testExtension.await();
    }

    private Message generateMessageContent() throws IOException {
        return Message.Builder.of().setSubject("toto").setBody("content", StandardCharsets.UTF_8).build();
    }

    @Test
    void ghostMailboxBugShouldChangeMailboxId() {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        Assertions.assertThat((Object)this.aliceGhostInboxId).isNotEqualTo((Object)newAliceInbox);
    }

    @Test
    void ghostMailboxBugShouldDiscardOldContent() {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        RabbitMQFixture.calmlyAwait.timeout(THIRTY_SECONDS).untilAsserted(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)this.accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + newAliceInbox.serialize() + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)1), new Object[0])).body("[0][1].messageIds", Matchers.not((Matcher)Matchers.contains((Object[])new String[]{this.message1.getMessageId().serialize()})), new Object[0])).body("[0][1].messageIds", Matchers.contains((Object[])new String[]{this.message2.getMessageId().serialize()}), new Object[0]));
    }

    @Test
    @Tag(value="unstable")
    void webadminCanMergeTwoMailboxes() {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        this.fixGhostMailboxes(newAliceInbox);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)this.accessToken.asString(), new Object[0]).body("[[\"getMessageList\", {\"filter\":{\"inMailboxes\":[\"" + newAliceInbox.serialize() + "\"]}}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"messageList"), new Object[0])).body("[0][1].messageIds", Matchers.hasSize((int)2), new Object[0])).body("[0][1].messageIds", Matchers.containsInAnyOrder((Object[])new String[]{this.message1.getMessageId().serialize(), this.message2.getMessageId().serialize()}), new Object[0]);
    }

    @Test
    void webadminCanMergeTwoMailboxesRights() throws Exception {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        this.aclProbe.addRights(this.aliceInboxPath, CEDRIC, MailboxACL.FULL_RIGHTS);
        this.fixGhostMailboxes(newAliceInbox);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)this.accessToken.asString(), new Object[0]).body("[[\"getMailboxes\", {\"ids\": [\"" + newAliceInbox.serialize() + "\"]}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"mailboxes"), new Object[0])).body("[0][1].list[0].sharedWith", Matchers.hasKey((Object)BOB), new Object[0])).body("[0][1].list[0].sharedWith", Matchers.hasKey((Object)CEDRIC), new Object[0]);
    }

    @Test
    void oldGhostedMailboxShouldNoMoreBeAccessible() throws Exception {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        this.aclProbe.addRights(this.aliceInboxPath, CEDRIC, MailboxACL.FULL_RIGHTS);
        this.fixGhostMailboxes(newAliceInbox);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("Authorization", (Object)this.accessToken.asString(), new Object[0]).body("[[\"getMailboxes\", {\"ids\": [\"" + this.aliceGhostInboxId.serialize() + "\"]}, \"#0\"]]").when().post("/jmap", new Object[0])).then()).statusCode(200)).body(NAME, Matchers.equalTo((Object)"mailboxes"), new Object[0])).body("[0][1].list", Matchers.hasSize((int)0), new Object[0]);
    }

    @Test
    void mergingMailboxTaskShouldBeInformative() {
        MailboxId newAliceInbox = this.mailboxProbe.getMailboxId("#private", ALICE, "INBOX");
        String taskId = this.fixGhostMailboxes(newAliceInbox);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.with().spec(this.webadminSpecification).basePath("/tasks").when().get(taskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)TaskManager.Status.COMPLETED.getValue()), new Object[0])).body("taskId", Matchers.is((Object)taskId), new Object[0])).body("additionalInformation.oldMailboxId", Matchers.is((Object)this.aliceGhostInboxId.serialize()), new Object[0])).body("additionalInformation.newMailboxId", Matchers.is((Object)newAliceInbox.serialize()), new Object[0])).body("additionalInformation.totalMessageCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.messageMovedCount", Matchers.is((Object)1), new Object[0])).body("additionalInformation.messageFailedCount", Matchers.is((Object)0), new Object[0])).body("type", Matchers.is((Object)MailboxMergingTask.MAILBOX_MERGING.asString()), new Object[0])).body("submitDate", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())), new Object[0])).body("startedDate", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())), new Object[0])).body("completedDate", Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())), new Object[0]);
    }

    private String fixGhostMailboxes(MailboxId newAliceInbox) {
        String taskId = ((Response)RestAssured.given().spec(this.webadminSpecification).body("{    \"mergeOrigin\":\"" + this.aliceGhostInboxId.serialize() + "\",    \"mergeDestination\":\"" + newAliceInbox.serialize() + "\"}").post("/cassandra/mailbox/merging", new Object[0])).jsonPath().getString("taskId");
        RestAssured.given().spec(this.webadminSpecification).basePath("/tasks").get(taskId + "/await", new Object[0]);
        testExtension.await();
        return taskId;
    }
}

