/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration.rabbitmq;

import com.datastax.driver.core.Session;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.time.Duration;
import org.apache.james.CassandraExtension;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.CassandraRabbitMQJamesServerMain;
import org.apache.james.DockerElasticSearchExtension;
import org.apache.james.GuiceJamesServer;
import org.apache.james.GuiceModuleTestExtension;
import org.apache.james.JamesServerBuilder;
import org.apache.james.JamesServerExtension;
import org.apache.james.SearchConfiguration;
import org.apache.james.backends.cassandra.Scenario;
import org.apache.james.backends.cassandra.TestingSession;
import org.apache.james.backends.cassandra.init.SessionWithInitializedTablesFactory;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.jmap.JMAPTestingConstants;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.modules.AwsS3BlobStoreExtension;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.modules.RabbitMQExtension;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.protocols.ImapGuiceProbe;
import org.apache.james.modules.protocols.SmtpGuiceProbe;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.Port;
import org.apache.james.utils.DataProbeImpl;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.MailRepositoryProbeImpl;
import org.apache.james.utils.SMTPMessageSender;
import org.apache.james.utils.TestIMAPClient;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@Tag(value="BasicFeature")
class ConsistencyTasksIntegrationTest {
    @RegisterExtension
    static JamesServerExtension testExtension = new JamesServerBuilder(tmpDir -> CassandraRabbitMQJamesConfiguration.builder().workingDirectory(tmpDir).configurationFromClasspath().blobStore(BlobStoreConfiguration.builder().s3().disableCache().deduplication().noCryptoConfig()).searchConfiguration(SearchConfiguration.elasticSearch()).build()).extension((GuiceModuleTestExtension)new DockerElasticSearchExtension()).extension((GuiceModuleTestExtension)new CassandraExtension()).extension((GuiceModuleTestExtension)new AwsS3BlobStoreExtension()).extension((GuiceModuleTestExtension)new RabbitMQExtension()).server(configuration -> CassandraRabbitMQJamesServerMain.createServer((CassandraRabbitMQJamesConfiguration)configuration).overrideWith(new Module[]{binder -> binder.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.builder().maxRetries(1).firstBackoff(Duration.ofMillis(2L)).jitterFactor(0.5).build())}).overrideWith(new Module[]{new TestingSessionModule()})).build();
    @RegisterExtension
    TestIMAPClient testIMAPClient = new TestIMAPClient();
    @RegisterExtension
    SMTPMessageSender smtpMessageSender = new SMTPMessageSender("domain.tld");
    private static final String VERSION = "/cassandra/version";
    private static final String UPGRADE_VERSION = "/cassandra/version/upgrade";
    private static final String UPGRADE_TO_LATEST_VERSION = "/cassandra/version/upgrade/latest";
    private static final String USERNAME = "username@domain.tld";
    private static final String ALIAS_1 = "alias1@domain.tld";
    private static final String ALIAS_2 = "alias2@domain.tld";
    private static final String MESSAGE = "Subject: test\r\n\r\ntestmail";
    private static final String JAMES_SERVER_HOST = "127.0.0.1";
    private static final String TEST_MAILBOX = "TEST";
    private DataProbe dataProbe;

    ConsistencyTasksIntegrationTest() {
    }

    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) throws Exception {
        this.dataProbe = (DataProbe)guiceJamesServer.getProbe(DataProbeImpl.class);
        this.dataProbe.fluent().addDomain("domain.tld").addUser(JMAPTestingConstants.ALICE.asString(), "789123").addUser(JMAPTestingConstants.BOB.asString(), "123456");
        ((QuotaProbesImpl)guiceJamesServer.getProbe(QuotaProbesImpl.class)).setGlobalMaxMessageCount(QuotaCountLimit.count((long)50L));
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void shouldSolveCassandraMappingInconsistency(GuiceJamesServer server) {
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().times(1).whenQueryStartsWith("INSERT INTO mappings_sources")});
        RestAssured.with().put("address/aliases/username@domain.tld/sources/alias1@domain.tld", new Object[0]);
        RestAssured.with().put("address/aliases/username@domain.tld/sources/alias2@domain.tld", new Object[0]);
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"SolveInconsistencies"}).post("cassandra/mappings", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/aliases/username@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{ALIAS_1, ALIAS_2}), new Object[0]);
    }

    @Test
    void shouldSolveMailboxesInconsistency(GuiceJamesServer server) {
        String upgradeTaskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + upgradeTaskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("INSERT INTO mailbox (id,name,uidvalidity,mailboxbase)")});
        try {
            this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").create(TEST_MAILBOX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.executeNormally().forever().whenQueryStartsWith("INSERT INTO mailbox (id,name,uidvalidity,mailboxbase)")});
        String solveConsistenciesTaskId = (String)((Response)RestAssured.with().header("I-KNOW-WHAT-I-M-DOING", (Object)"ALL-SERVICES-ARE-OFFLINE", new Object[0]).queryParam("task", new Object[]{"SolveInconsistencies"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(solveConsistenciesTaskId + "/await", new Object[0]);
        Assertions.assertThatCode(() -> this.testIMAPClient.create(TEST_MAILBOX)).doesNotThrowAnyException();
    }

    @Tag(value="unstable")
    @Test
    void shouldRecomputeMailboxCounters(GuiceJamesServer server) throws Exception {
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("UPDATE mailboxCounters SET count=count+1,unseen=unseen+1 WHERE mailboxId=:mailboxId;")});
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)((MailRepositoryProbeImpl)server.getProbe(MailRepositoryProbeImpl.class)).getRepositoryMailCount(MailRepositoryUrl.from((String)"cassandra://var/mail/error/"))).isGreaterThanOrEqualTo(1L));
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.executeNormally().forever().whenQueryStartsWith("UPDATE mailboxCounters SET count=count+1,unseen=unseen+1 WHERE mailboxId=:mailboxId;")});
        String taskId = (String)((Response)RestAssured.with().basePath("/mailboxes").queryParam("task", new Object[]{"RecomputeMailboxCounters"}).post()).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX");
        Assertions.assertThat((long)this.testIMAPClient.getMessageCount("INBOX")).isEqualTo(4L);
    }

    @Test
    void shouldRecomputeQuotas(GuiceJamesServer server) throws Exception {
        Scenario.Barrier barrier1 = new Scenario.Barrier();
        Scenario.Barrier barrier2 = new Scenario.Barrier();
        String updatedQuotaQueryString = "UPDATE currentQuota SET messageCount=messageCount+?,storage=storage+? WHERE quotaRoot=?;";
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.awaitOn((Scenario.Barrier)barrier1).thenFail().times(1).whenQueryStartsWith(updatedQuotaQueryString), Scenario.Builder.awaitOn((Scenario.Barrier)barrier2).thenFail().times(1).whenQueryStartsWith(updatedQuotaQueryString)});
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX").awaitMessage(Awaitility.await());
        barrier1.awaitCaller();
        barrier1.releaseCaller();
        barrier2.awaitCaller();
        barrier2.releaseCaller();
        String taskId = (String)((Response)RestAssured.with().basePath("/quota/users").queryParam("task", new Object[]{"RecomputeCurrentQuotas"}).post()).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((String)this.testIMAPClient.getQuotaRoot("INBOX")).contains(new CharSequence[]{"* QUOTAROOT \"INBOX\" #private&bob@domain.tld\r\n* QUOTA #private&bob@domain.tld (MESSAGE 1 50)"});
    }

    @Test
    void shouldSolveMessagesInconsistency(GuiceJamesServer server) throws IOException {
        String upgradeTaskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + upgradeTaskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        TestingSessionProbe testingProbe = (TestingSessionProbe)server.getProbe(TestingSessionProbe.class);
        testingProbe.getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.fail().forever().whenQueryStartsWith("UPDATE messageIdTable")});
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)((MailRepositoryProbeImpl)server.getProbe(MailRepositoryProbeImpl.class)).getRepositoryMailCount(MailRepositoryUrl.from((String)"cassandra://var/mail/error/"))).isEqualTo(1L));
        testingProbe.getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.executeNormally().forever().whenQueryStartsWith("UPDATE messageIdTable")});
        String solveInconsistenciesTaskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"SolveInconsistencies"}).post("/messages", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(solveInconsistenciesTaskId + "/await", new Object[0]);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX");
        Assertions.assertThat((String)this.testIMAPClient.readFirstMessage()).contains(new CharSequence[]{MESSAGE});
    }

    @Test
    void solveCassandraMappingInconsistencyShouldSolveNothingWhenNoInconsistencies() {
        RestAssured.with().put("address/aliases/username@domain.tld/sources/alias1@domain.tld", new Object[0]);
        RestAssured.with().put("address/aliases/username@domain.tld/sources/alias2@domain.tld", new Object[0]);
        String taskId = (String)((Response)RestAssured.with().queryParam("action", new Object[]{"SolveInconsistencies"}).post("cassandra/mappings", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("address/aliases/username@domain.tld", new Object[0])).then()).contentType(ContentType.JSON)).statusCode(200)).body("source", CoreMatchers.hasItems((Object[])new String[]{ALIAS_1, ALIAS_2}), new Object[0]);
    }

    @Test
    void solveMailboxesInconsistencyShouldSolveNothingWhenNoInconsistencies(GuiceJamesServer server) throws Exception {
        String upgradeTaskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + upgradeTaskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").create(TEST_MAILBOX);
        String solveInconsistenciesTaskId = (String)((Response)RestAssured.with().header("I-KNOW-WHAT-I-M-DOING", (Object)"ALL-SERVICES-ARE-OFFLINE", new Object[0]).queryParam("task", new Object[]{"SolveInconsistencies"}).post("/mailboxes", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(solveInconsistenciesTaskId + "/await", new Object[0]);
        Assertions.assertThatCode(() -> this.testIMAPClient.create(TEST_MAILBOX)).hasMessageContaining("Mailbox already exists");
    }

    @Test
    void recomputeMailboxCountersShouldSolveNothingWhenNoInconsistencies(GuiceJamesServer server) throws Exception {
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX").awaitMessage(Awaitility.await());
        String taskId = (String)((Response)RestAssured.with().basePath("/mailboxes").queryParam("task", new Object[]{"RecomputeMailboxCounters"}).post()).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((long)this.testIMAPClient.getMessageCount("INBOX")).isEqualTo(1L);
    }

    @Test
    void recomputeQuotasShouldSolveNothingWhenNoInconsistencies(GuiceJamesServer server) throws Exception {
        Scenario.Barrier barrier = new Scenario.Barrier();
        ((TestingSessionProbe)server.getProbe(TestingSessionProbe.class)).getTestingSession().registerScenario(new Scenario.ExecutionHook[]{Scenario.Builder.awaitOn((Scenario.Barrier)barrier).thenExecuteNormally().times(1).whenQueryStartsWith("UPDATE currentQuota SET messageCount=messageCount+?,storage=storage+? WHERE quotaRoot=?;")});
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX").awaitMessage(Awaitility.await());
        barrier.awaitCaller();
        barrier.releaseCaller();
        String taskId = (String)((Response)RestAssured.with().basePath("/quota/users").queryParam("task", new Object[]{"RecomputeCurrentQuotas"}).post()).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(taskId + "/await", new Object[0]);
        Assertions.assertThat((String)this.testIMAPClient.getQuotaRoot("INBOX")).contains(new CharSequence[]{"* QUOTAROOT \"INBOX\" #private&bob@domain.tld\r\n* QUOTA #private&bob@domain.tld (MESSAGE 1 50)"});
    }

    @Test
    void solveMessagesInconsistencyShouldSolveNothingWhenNoInconsistencies(GuiceJamesServer server) throws Exception {
        String upgradeTaskId = (String)((Response)RestAssured.with().post(UPGRADE_TO_LATEST_VERSION, new Object[0])).jsonPath().get("taskId");
        ((ValidatableResponse)((Response)RestAssured.with().get("/tasks/" + upgradeTaskId + "/await", new Object[0])).then()).body("status", Matchers.is((Object)"completed"), new Object[0]);
        this.smtpMessageSender.connect(JAMES_SERVER_HOST, ((SmtpGuiceProbe)server.getProbe(SmtpGuiceProbe.class)).getSmtpPort()).sendMessageWithHeaders(JMAPTestingConstants.ALICE.asString(), JMAPTestingConstants.BOB.asString(), MESSAGE);
        this.testIMAPClient.connect(JAMES_SERVER_HOST, ((ImapGuiceProbe)server.getProbe(ImapGuiceProbe.class)).getImapPort()).login(JMAPTestingConstants.BOB, "123456").select("INBOX").awaitMessage(Awaitility.await());
        String solveInconsistenciesTaskId = (String)((Response)RestAssured.with().queryParam("task", new Object[]{"SolveInconsistencies"}).post("/messages", new Object[0])).jsonPath().get("taskId");
        RestAssured.with().basePath("/tasks").get(solveInconsistenciesTaskId + "/await", new Object[0]);
        Assertions.assertThat((String)this.testIMAPClient.readFirstMessage()).contains(new CharSequence[]{MESSAGE});
    }

    private static class TestingSessionProbe
    implements GuiceProbe {
        private final TestingSession testingSession;

        @Inject
        private TestingSessionProbe(TestingSession testingSession) {
            this.testingSession = testingSession;
        }

        public TestingSession getTestingSession() {
            return this.testingSession;
        }
    }

    private static class TestingSessionModule
    extends AbstractModule {
        private TestingSessionModule() {
        }

        protected void configure() {
            Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(TestingSessionProbe.class);
            this.bind(Session.class).to(TestingSession.class);
        }

        @Provides
        @Singleton
        TestingSession provideSession(SessionWithInitializedTablesFactory factory) {
            return new TestingSession(factory.get());
        }
    }
}

