/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.netty;

import com.google.common.base.Optional;
import com.sun.mail.smtp.SMTPTransport;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SMTPSClient;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.logger.Logger;
import org.apache.james.protocols.api.utils.BogusSSLSocketFactory;
import org.apache.james.protocols.api.utils.BogusSslContextFactory;
import org.apache.james.protocols.api.utils.BogusTrustManagerFactory;
import org.apache.james.protocols.api.utils.MockLogger;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.NettyServer;
import org.apache.james.protocols.smtp.AllButStartTlsLineDelimiterChannelHandlerFactory;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPConfigurationImpl;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.protocols.smtp.SMTPProtocolHandlerChain;
import org.apache.james.protocols.smtp.utils.TestMessageHook;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;

public class NettyStartTlsSMTPServerTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int RANDOM_PORT = 0;
    private SMTPSClient smtpsClient = null;
    private ProtocolServer server = null;

    @After
    public void tearDown() throws Exception {
        if (this.smtpsClient != null) {
            this.smtpsClient.disconnect();
        }
        if (this.server != null) {
            this.server.unbind();
        }
    }

    private ProtocolServer createServer(Protocol protocol, Encryption enc) {
        NettyServer server = NettyServer.builder().protocol(protocol).secure(enc).frameHandlerFactory((ChannelHandlerFactory)new AllButStartTlsLineDelimiterChannelHandlerFactory(8192)).build();
        server.setListenAddresses(new InetSocketAddress[]{new InetSocketAddress(LOCALHOST_IP, 0)});
        return server;
    }

    private SMTPSClient createClient() {
        SMTPSClient client = new SMTPSClient(false, BogusSslContextFactory.getClientContext());
        client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
        return client;
    }

    private Protocol createProtocol(Optional<ProtocolHandler> handler) throws WiringException {
        SMTPProtocolHandlerChain chain = new SMTPProtocolHandlerChain((MetricFactory)new NoopMetricFactory());
        if (handler.isPresent()) {
            chain.add((ProtocolHandler)handler.get());
        }
        chain.wireExtensibleHandlers();
        return new SMTPProtocol((ProtocolHandlerChain)chain, (SMTPConfiguration)new SMTPConfigurationImpl(), (Logger)new MockLogger());
    }

    @Test
    public void connectShouldReturnTrueWhenConnecting() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)this.smtpsClient.getReplyCode())).isTrue();
    }

    @Test
    public void ehloShouldReturnTrueWhenSendingTheCommand() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.smtpsClient.sendCommand("EHLO localhost");
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)this.smtpsClient.getReplyCode())).isTrue();
    }

    @Test
    public void startTlsShouldBeAnnouncedWhenServerSupportsIt() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.smtpsClient.sendCommand("EHLO localhost");
        ((StartTLSAssert)Assertions.assertThat((AssertDelegateTarget)new StartTLSAssert(this.smtpsClient))).isStartTLSAnnounced();
    }

    @Test
    public void startTlsShouldReturnTrueWhenServerSupportsIt() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.smtpsClient.sendCommand("EHLO localhost");
        boolean execTLS = this.smtpsClient.execTLS();
        Assertions.assertThat((boolean)execTLS).isTrue();
    }

    @Test
    public void startTlsShouldFailWhenFollowedByInjectedCommand() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.smtpsClient.sendCommand("EHLO localhost");
        this.smtpsClient.sendCommand("STARTTLS\r\nRSET\r\n");
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)this.smtpsClient.getReplyCode())).isFalse();
    }

    @Test
    public void startTlsShouldFailWhenFollowedByInjectedCommandAndNotAtBeginningOfLine() throws Exception {
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.absent()), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.smtpsClient = this.createClient();
        this.server.bind();
        InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
        this.smtpsClient.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        this.smtpsClient.sendCommand("EHLO localhost");
        this.smtpsClient.sendCommand("RSET\r\nSTARTTLS\r\nRSET\r\n");
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)this.smtpsClient.getReplyCode())).isFalse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startTlsShouldWorkWhenUsingJavamail() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        this.server = this.createServer(this.createProtocol((Optional<ProtocolHandler>)Optional.of((Object)hook)), Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
        this.server.bind();
        SMTPTransport transport = null;
        try {
            InetSocketAddress bindedAddress = new ProtocolServerUtils(this.server).retrieveBindedAddress();
            Properties mailProps = new Properties();
            mailProps.put("mail.smtp.from", "test@localhost");
            mailProps.put("mail.smtp.host", bindedAddress.getHostName());
            mailProps.put("mail.smtp.port", (Object)bindedAddress.getPort());
            mailProps.put("mail.smtp.socketFactory.class", BogusSSLSocketFactory.class.getName());
            mailProps.put("mail.smtp.socketFactory.fallback", "false");
            mailProps.put("mail.smtp.starttls.enable", "true");
            Session mailSession = Session.getDefaultInstance((Properties)mailProps);
            InternetAddress[] rcpts = new InternetAddress[]{new InternetAddress("valid@localhost")};
            MimeMessage message = new MimeMessage(mailSession);
            message.setFrom((Address)new InternetAddress("test@localhost"));
            message.setRecipients(Message.RecipientType.TO, (Address[])rcpts);
            message.setSubject("Testmail", "UTF-8");
            message.setText("Test.....");
            transport = (SMTPTransport)mailSession.getTransport("smtps");
            transport.connect(new Socket(bindedAddress.getHostName(), bindedAddress.getPort()));
            transport.sendMessage((Message)message, (Address[])rcpts);
            Assertions.assertThat(hook.getQueued()).hasSize(1);
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }

    private static class StartTLSAssert
    implements AssertDelegateTarget {
        private final SMTPSClient client;

        public StartTLSAssert(SMTPSClient client) {
            this.client = client;
        }

        public boolean isStartTLSAnnounced() {
            for (String reply : this.client.getReplyStrings()) {
                if (!reply.toUpperCase(Locale.US).endsWith("STARTTLS")) continue;
                return true;
            }
            return false;
        }
    }
}

