/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.ValidSenderDomainHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Test;

public class ValidSenderDomainHandlerTest {
    private ValidSenderDomainHandler createHandler() {
        return new ValidSenderDomainHandler(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            protected boolean hasMXRecord(SMTPSession session, String domain) {
                return domain.equals("test.james.apache.org");
            }
        };
    }

    private SMTPSession setupMockedSession(final MailAddress sender) {
        return new BaseFakeSMTPSession(){
            HashMap<String, Object> map = new HashMap();

            @Override
            public Map<String, Object> getState() {
                this.map.put("SENDER_ADDRESS", sender);
                return this.map;
            }

            @Override
            public boolean isRelayingAllowed() {
                return false;
            }

            @Override
            public Object setAttachment(String key, Object value, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    throw new UnsupportedOperationException();
                }
                if (value == null) {
                    return this.getState().remove(key);
                }
                return this.getState().put(key, value);
            }

            @Override
            public Object getAttachment(String key, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    throw new UnsupportedOperationException();
                }
                return this.getState().get(key);
            }
        };
    }

    @Test
    public void testNullSenderNotReject() {
        ValidSenderDomainHandler handler = this.createHandler();
        int response = handler.doMail(this.setupMockedSession(null), null).getResult();
        Assert.assertEquals((String)"Not blocked cause its a nullsender", (int)response, (int)8);
    }

    @Test
    public void testInvalidSenderDomainReject() throws MailAddressException {
        ValidSenderDomainHandler handler = this.createHandler();
        SMTPSession session = this.setupMockedSession(new MailAddress("invalid@invalid"));
        int response = handler.doMail(session, (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction)).getResult();
        Assert.assertEquals((String)"Blocked cause we use reject action", (int)response, (int)2);
    }
}

