/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.SpamTrapHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Test;

public class SpamTrapHandlerTest {
    private static final String SPAM_TRAP_RECIP1 = "spamtrap1@localhost";
    private static final String RECIP1 = "recip@localhost";

    private SMTPSession setUpSMTPSession(final String ip) {
        return new BaseFakeSMTPSession(){

            @Override
            public InetSocketAddress getRemoteAddress() {
                return new InetSocketAddress(this.getRemoteIPAddress(), 10000);
            }

            public String getRemoteIPAddress() {
                return ip;
            }
        };
    }

    @Test
    public void testSpamTrap() throws MailAddressException {
        String ip = "192.168.100.1";
        String ip2 = "192.168.100.2";
        long blockTime = 2000L;
        ArrayList<String> rcpts = new ArrayList<String>();
        rcpts.add(SPAM_TRAP_RECIP1);
        SpamTrapHandler handler = new SpamTrapHandler();
        handler.setBlockTime(blockTime);
        handler.setSpamTrapRecipients(rcpts);
        int result = handler.doRcpt(this.setUpSMTPSession(ip), null, new MailAddress(SPAM_TRAP_RECIP1)).getResult();
        Assert.assertEquals((String)"Blocked on first connect", (int)2, (int)result);
        result = handler.doRcpt(this.setUpSMTPSession(ip), null, new MailAddress(RECIP1)).getResult();
        Assert.assertEquals((String)"Blocked on second connect", (int)2, (int)result);
        result = handler.doRcpt(this.setUpSMTPSession(ip2), null, new MailAddress(RECIP1)).getResult();
        Assert.assertEquals((String)"Not Blocked", (int)8, (int)result);
        try {
            Thread.sleep(blockTime);
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Failed to sleep for " + blockTime + " ms"));
        }
        result = handler.doRcpt(this.setUpSMTPSession(ip), null, new MailAddress(RECIP1)).getResult();
        Assert.assertEquals((String)"Not blocked. BlockTime exceeded", (int)8, (int)result);
    }
}

