/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.ResolvableEhloHeloHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Test;

public class ResolvableEhloHeloHandlerTest {
    public static final String INVALID_HOST = "foo.bar";
    public static final String VALID_HOST = "james.apache.org";

    private SMTPSession setupMockSession(String argument, final boolean relaying, final boolean authRequired, final String user, MailAddress recipient) {
        return new BaseFakeSMTPSession(){
            HashMap<String, Object> connectionMap = new HashMap();
            HashMap<String, Object> map = new HashMap();

            @Override
            public boolean isAuthSupported() {
                return authRequired;
            }

            @Override
            public String getUser() {
                return user;
            }

            @Override
            public Map<String, Object> getConnectionState() {
                return this.connectionMap;
            }

            @Override
            public boolean isRelayingAllowed() {
                return relaying;
            }

            @Override
            public Map<String, Object> getState() {
                return this.map;
            }

            @Override
            public Object setAttachment(String key, Object value, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    if (value == null) {
                        return this.connectionMap.remove(key);
                    }
                    return this.connectionMap.put(key, value);
                }
                if (value == null) {
                    return this.map.remove(key);
                }
                return this.connectionMap.put(key, value);
            }

            @Override
            public Object getAttachment(String key, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    return this.connectionMap.get(key);
                }
                return this.connectionMap.get(key);
            }
        };
    }

    private ResolvableEhloHeloHandler createHandler() {
        return new ResolvableEhloHeloHandler(){

            protected String resolve(String host) throws UnknownHostException {
                if (host.equals(ResolvableEhloHeloHandlerTest.INVALID_HOST)) {
                    throw new UnknownHostException();
                }
                return InetAddress.getLocalHost().getHostName();
            }
        };
    }

    @Test
    public void testRejectInvalidHelo() throws MailAddressException {
        MailAddress mailAddress = new MailAddress("test@localhost");
        SMTPSession session = this.setupMockSession(INVALID_HOST, false, false, null, mailAddress);
        ResolvableEhloHeloHandler handler = this.createHandler();
        handler.doHelo(session, INVALID_HOST);
        Assert.assertNotNull((String)"Invalid HELO", (Object)session.getAttachment("BAD_EHLO_HELO", ProtocolSession.State.Transaction));
        int result = handler.doRcpt(session, null, mailAddress).getResult();
        Assert.assertEquals((String)"Reject", (int)result, (int)2);
    }

    @Test
    public void testNotRejectValidHelo() throws MailAddressException {
        MailAddress mailAddress = new MailAddress("test@localhost");
        SMTPSession session = this.setupMockSession(VALID_HOST, false, false, null, mailAddress);
        ResolvableEhloHeloHandler handler = this.createHandler();
        handler.doHelo(session, VALID_HOST);
        Assert.assertNull((String)"Valid HELO", (Object)session.getAttachment("BAD_EHLO_HELO", ProtocolSession.State.Transaction));
        int result = handler.doRcpt(session, null, mailAddress).getResult();
        Assert.assertEquals((String)"Not reject", (int)result, (int)8);
    }

    @Test
    public void testRejectInvalidHeloAuthUser() throws MailAddressException {
        MailAddress mailAddress = new MailAddress("test@localhost");
        SMTPSession session = this.setupMockSession(INVALID_HOST, false, true, "valid@user", mailAddress);
        ResolvableEhloHeloHandler handler = this.createHandler();
        handler.doHelo(session, INVALID_HOST);
        Assert.assertNotNull((String)"Value stored", (Object)session.getAttachment("BAD_EHLO_HELO", ProtocolSession.State.Transaction));
        int result = handler.doRcpt(session, null, mailAddress).getResult();
        Assert.assertEquals((String)"Reject", (int)result, (int)2);
    }

    @Test
    public void testRejectRelay() throws MailAddressException {
        MailAddress mailAddress = new MailAddress("test@localhost");
        SMTPSession session = this.setupMockSession(INVALID_HOST, true, false, null, mailAddress);
        ResolvableEhloHeloHandler handler = this.createHandler();
        handler.doHelo(session, INVALID_HOST);
        Assert.assertNotNull((String)"Value stored", (Object)session.getAttachment("BAD_EHLO_HELO", ProtocolSession.State.Transaction));
        int result = handler.doRcpt(session, null, mailAddress).getResult();
        Assert.assertEquals((String)"Reject", (int)result, (int)2);
    }
}

