/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.MaxUnknownCmdHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Test;

public class MaxUnknownCmdHandlerTest {
    @Test
    public void testRejectAndClose() throws MailAddressException {
        BaseFakeSMTPSession session = new BaseFakeSMTPSession(){
            private final HashMap<String, Object> map = new HashMap();

            @Override
            public Map<String, Object> getState() {
                return this.map;
            }

            @Override
            public Object setAttachment(String key, Object value, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    throw new UnsupportedOperationException();
                }
                if (value == null) {
                    return this.map.remove(key);
                }
                return this.map.put(key, value);
            }

            @Override
            public Object getAttachment(String key, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    throw new UnsupportedOperationException();
                }
                return this.map.get(key);
            }
        };
        MaxUnknownCmdHandler handler = new MaxUnknownCmdHandler();
        handler.setMaxUnknownCmdCount(2);
        int resp = handler.doUnknown((SMTPSession)session, "what").getResult();
        Assert.assertEquals((int)8, (int)resp);
        resp = handler.doUnknown((SMTPSession)session, "what").getResult();
        Assert.assertEquals((int)8, (int)resp);
        resp = handler.doUnknown((SMTPSession)session, "what").getResult();
        Assert.assertEquals((int)18, (int)resp);
    }
}

