/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.MaxRcptHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Test;

public class MaxRcptHandlerTest {
    private SMTPSession setupMockedSession(final int rcptCount) {
        return new BaseFakeSMTPSession(){
            HashMap<String, Object> state = new HashMap();

            @Override
            public Map<String, Object> getState() {
                return this.state;
            }

            @Override
            public boolean isRelayingAllowed() {
                return false;
            }

            @Override
            public int getRcptCount() {
                return rcptCount;
            }
        };
    }

    @Test
    public void testRejectMaxRcpt() throws MailAddressException {
        SMTPSession session = this.setupMockedSession(3);
        MaxRcptHandler handler = new MaxRcptHandler();
        handler.setMaxRcpt(2);
        int resp = handler.doRcpt(session, null, new MailAddress("test@test")).getResult();
        Assert.assertEquals((String)"Rejected.. To many recipients", (int)resp, (int)2);
    }

    @Test
    public void testNotRejectMaxRcpt() throws MailAddressException {
        SMTPSession session = this.setupMockedSession(3);
        MaxRcptHandler handler = new MaxRcptHandler();
        handler.setMaxRcpt(4);
        int resp = handler.doRcpt(session, null, new MailAddress("test@test")).getResult();
        Assert.assertEquals((String)"Not Rejected..", (int)resp, (int)8);
    }
}

