/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailAddressException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.DNSRBLHandler;
import org.apache.james.protocols.smtp.utils.BaseFakeSMTPSession;
import org.junit.Before;
import org.junit.Test;

public class DNSRBLHandlerTest {
    private SMTPSession mockedSMTPSession;
    private String remoteIp = "127.0.0.2";
    private boolean relaying = false;
    public static final String RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.blocklisted";
    public static final String RBL_DETAIL_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.detail";

    @Before
    public void setUp() throws Exception {
        this.setRelayingAllowed(false);
    }

    private void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    private void setRelayingAllowed(boolean relaying) {
        this.relaying = relaying;
    }

    private DNSRBLHandler createHandler() {
        return new DNSRBLHandler(){

            protected boolean resolve(String host) {
                if ("2.0.0.127.bl.spamcop.net.".equals(host)) {
                    return true;
                }
                if ("3.0.0.127.bl.spamcop.net.".equals(host)) {
                    return true;
                }
                if ("1.0.168.192.bl.spamcop.net.".equals(host)) {
                    return false;
                }
                throw new UnsupportedOperationException("getByName(" + host + ") not implemented in DNSRBLHandlerTest mock");
            }

            protected Collection<String> resolveTXTRecords(String hostname) {
                ArrayList<String> res = new ArrayList<String>();
                if (hostname == null) {
                    return res;
                }
                if ("2.0.0.127.bl.spamcop.net.".equals(hostname)) {
                    res.add("Blocked - see http://www.spamcop.net/bl.shtml?127.0.0.2");
                }
                return res;
            }
        };
    }

    private void setupMockedSMTPSession(MailAddress rcpt) {
        this.mockedSMTPSession = new BaseFakeSMTPSession(){
            HashMap<String, Object> sessionState = new HashMap();
            HashMap<String, Object> connectionState = new HashMap();

            @Override
            public InetSocketAddress getRemoteAddress() {
                return new InetSocketAddress(this.getRemoteIPAddress(), 10000);
            }

            public String getRemoteIPAddress() {
                return DNSRBLHandlerTest.this.remoteIp;
            }

            @Override
            public Map<String, Object> getState() {
                return this.sessionState;
            }

            @Override
            public boolean isRelayingAllowed() {
                return DNSRBLHandlerTest.this.relaying;
            }

            @Override
            public boolean isAuthSupported() {
                return false;
            }

            @Override
            public int getRcptCount() {
                return 0;
            }

            @Override
            public Object setAttachment(String key, Object value, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    if (value == null) {
                        return this.connectionState.remove(key);
                    }
                    return this.connectionState.put(key, value);
                }
                if (value == null) {
                    return this.sessionState.remove(key);
                }
                return this.sessionState.put(key, value);
            }

            @Override
            public Object getAttachment(String key, ProtocolSession.State state) {
                if (state == ProtocolSession.State.Connection) {
                    return this.connectionState.get(key);
                }
                return this.sessionState.get(key);
            }
        };
    }

    @Test
    public void testBlackListedTextPresent() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setBlacklist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(true);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertEquals((String)"Details", (Object)"Blocked - see http://www.spamcop.net/bl.shtml?127.0.0.2", (Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNotNull((String)"Blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }

    @Test
    public void testGetNoDetail() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setBlacklist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(false);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertNull((String)"No details", (Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNotNull((String)"Blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }

    @Test
    public void testRelayAllowed() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setRelayingAllowed(true);
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setBlacklist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(true);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertNull((String)"No details", (Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNull((String)"Not blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }

    @Test
    public void testNotBlackListed() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setRemoteIp("192.168.0.1");
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setBlacklist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(true);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertNull((String)"No details", (Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNull((String)"Not blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }

    @Test
    public void testBlackListedNoTxt() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setRemoteIp("127.0.0.3");
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setBlacklist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(true);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertNull((Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNotNull((String)"Blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }

    @Test
    public void testWhiteListed() throws MailAddressException {
        DNSRBLHandler rbl = this.createHandler();
        this.setRemoteIp("127.0.0.2");
        this.setupMockedSMTPSession(new MailAddress("any@domain"));
        rbl.setWhitelist(new String[]{"bl.spamcop.net."});
        rbl.setGetDetail(true);
        rbl.doRcpt(this.mockedSMTPSession, null, new MailAddress("test@localhost"));
        Assert.assertNull((Object)this.mockedSMTPSession.getAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
        Assert.assertNull((String)"Not blocked", (Object)this.mockedSMTPSession.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection));
    }
}

