/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.api.handler.DisconnectHandler;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.logger.Logger;
import org.apache.james.protocols.api.utils.MockLogger;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPConfigurationImpl;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.protocols.smtp.SMTPProtocolHandlerChain;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.james.protocols.smtp.utils.TestMessageHook;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class AbstractSMTPServerTest {
    protected static final String MSG1 = "Subject: Testmessage\r\n\r\nThis is a message\r\n";
    protected static final String SENDER = "me@sender";
    protected static final String RCPT1 = "rpct1@domain";
    protected static final String RCPT2 = "rpct2@domain";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleDelivery() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            this.send(server, bindedAddress, MSG1);
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env = queued.next();
            AbstractSMTPServerTest.checkEnvelope(env, SENDER, Arrays.asList(RCPT1, RCPT2), MSG1);
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeliveryWith4SimultaneousThreads() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            final ProtocolServer finalServer = server;
            final InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            final String mailContent = CharStreams.toString((Readable)new InputStreamReader(ClassLoader.getSystemResourceAsStream("a50.eml"), Charsets.US_ASCII));
            int threadCount = 4;
            int updateCount = 1;
            Assertions.assertThat((boolean)new ConcurrentTestRunner(threadCount, updateCount, new ConcurrentTestRunner.BiConsumer(){

                public void consume(int threadNumber, int step) throws Exception {
                    AbstractSMTPServerTest.this.send(finalServer, bindedAddress, mailContent);
                }
            }).run().awaitTermination(1L, TimeUnit.MINUTES)).isTrue();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env = queued.next();
            AbstractSMTPServerTest.checkEnvelope(env, SENDER, Arrays.asList(RCPT1, RCPT2), mailContent);
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env2 = queued.next();
            AbstractSMTPServerTest.checkEnvelope(env2, SENDER, Arrays.asList(RCPT1, RCPT2), mailContent);
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env3 = queued.next();
            AbstractSMTPServerTest.checkEnvelope(env3, SENDER, Arrays.asList(RCPT1, RCPT2), mailContent);
            Assertions.assertThat((boolean)queued.hasNext()).isTrue();
            MailEnvelope env4 = queued.next();
            AbstractSMTPServerTest.checkEnvelope(env4, SENDER, Arrays.asList(RCPT1, RCPT2), mailContent);
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    private void send(ProtocolServer server, InetSocketAddress bindedAddress, String msg) throws SocketException, IOException {
        SMTPClient client = this.createClient();
        client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
        client.helo("localhost");
        Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
        client.setSender(SENDER);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
        client.addRecipient(RCPT1);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
        client.addRecipient(RCPT2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
        Assertions.assertThat((boolean)client.sendShortMessageData(msg)).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
        client.quit();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
        client.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartTlsNotSupported() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.sendCommand("STARTTLS");
            Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownCommand() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.sendCommand("UNKNOWN");
            Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoop() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.noop();
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMailWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("localhost");
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.mail("invalid");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidHelo() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRcptWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.helo("localhost");
            Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.rcpt(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidNoBracketsEnformance() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            Protocol protocol = this.createProtocol(new ProtocolHandler[]{hook});
            ((SMTPConfigurationImpl)protocol.getConfiguration()).setUseAddressBracketsEnforcement(false);
            server = this.createServer(protocol);
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.mail(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeloEnforcement() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeloEnforcementDisabled() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            Protocol protocol = this.createProtocol(new ProtocolHandler[]{hook});
            ((SMTPConfigurationImpl)protocol.getConfiguration()).setHeloEhloEnforcement(false);
            server = this.createServer(protocol);
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = hook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeloHookPermanentError() throws Exception {
        HeloHook hook = new HeloHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doHelo(SMTPSession session, String helo) {
                return new HookResult(2);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeloHookTempraryError() throws Exception {
        HeloHook hook = new HeloHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doHelo(SMTPSession session, String helo) {
                return new HookResult(4);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativeTransient((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMailHookPermanentError() throws Exception {
        MailHook hook = new MailHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doMail(SMTPSession session, MailAddress sender) {
                return new HookResult(2);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMailHookTemporaryError() throws Exception {
        MailHook hook = new MailHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doMail(SMTPSession session, MailAddress sender) {
                return new HookResult(4);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativeTransient((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRcptHookPermanentError() throws Exception {
        RcptHook hook = new RcptHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
                if (AbstractSMTPServerTest.RCPT1.equals(rcpt.toString())) {
                    return new HookResult(2);
                }
                return new HookResult(8);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRcptHookTemporaryError() throws Exception {
        RcptHook hook = new RcptHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
                if (AbstractSMTPServerTest.RCPT1.equals(rcpt.toString())) {
                    return new HookResult(4);
                }
                return new HookResult(8);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativeTransient((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullSender() throws Exception {
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[0]));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender("");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT1);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageHookPermanentError() throws Exception {
        TestMessageHook testHook = new TestMessageHook();
        MessageHook hook = new MessageHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
                return new HookResult(2);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook, testHook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)client.sendShortMessageData(MSG1)).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = testHook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageHookTemporaryError() throws Exception {
        TestMessageHook testHook = new TestMessageHook();
        MessageHook hook = new MessageHook(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
                return new HookResult(4);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook, testHook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.helo("localhost");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.setSender(SENDER);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.addRecipient(RCPT2);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            Assertions.assertThat((boolean)client.sendShortMessageData(MSG1)).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativeTransient((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.quit();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Iterator<MailEnvelope> queued = testHook.getQueued().iterator();
            Assertions.assertThat((boolean)queued.hasNext()).isFalse();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectHandlerPermananet() throws Exception {
        ConnectHandler<SMTPSession> connectHandler = new ConnectHandler<SMTPSession>(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public Response onConnect(SMTPSession session) {
                return new SMTPResponse("554", (CharSequence)"Bye Bye");
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{connectHandler}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectHandlerTemporary() throws Exception {
        ConnectHandler<SMTPSession> connectHandler = new ConnectHandler<SMTPSession>(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public Response onConnect(SMTPSession session) {
                return new SMTPResponse("451", (CharSequence)"Bye Bye");
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{connectHandler}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isNegativeTransient((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisconnectHandler() throws Exception {
        final AtomicBoolean called = new AtomicBoolean(false);
        DisconnectHandler<SMTPSession> handler = new DisconnectHandler<SMTPSession>(){

            public void init(Configuration config) throws ConfigurationException {
            }

            public void destroy() {
            }

            public void onDisconnect(SMTPSession session) {
                called.set(true);
            }
        };
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{handler}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode())).as("Reply=" + client.getReplyString(), new Object[0])).isTrue();
            client.disconnect();
            Thread.sleep(1000L);
            Assertions.assertThat((boolean)called.get()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    protected SMTPClient createClient() {
        return new SMTPClient();
    }

    protected abstract ProtocolServer createServer(Protocol var1);

    protected Protocol createProtocol(ProtocolHandler ... handlers) throws WiringException {
        SMTPProtocolHandlerChain chain = new SMTPProtocolHandlerChain((MetricFactory)new NoopMetricFactory());
        chain.addAll(0, Arrays.asList(handlers));
        chain.wireExtensibleHandlers();
        return new SMTPProtocol((ProtocolHandlerChain)chain, (SMTPConfiguration)new SMTPConfigurationImpl(), (Logger)new MockLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkEnvelope(MailEnvelope env, String sender, List<String> recipients, String msg) throws IOException {
        Assertions.assertThat((String)env.getSender().toString()).isEqualTo((Object)sender);
        List envRecipients = env.getRecipients();
        Assertions.assertThat((int)envRecipients.size()).isEqualTo(recipients.size());
        for (int i = 0; i < recipients.size(); ++i) {
            MailAddress address = (MailAddress)envRecipients.get(i);
            Assertions.assertThat((String)address.toString()).isEqualTo((Object)recipients.get(i));
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(env.getMessageInputStream()));
            String line = null;
            boolean start = false;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Subject")) {
                    start = true;
                }
                if (!start) continue;
                sb.append(line);
                sb.append("\r\n");
            }
            String msgQueued = sb.subSequence(0, sb.length()).toString();
            Assertions.assertThat((int)msgQueued.length()).isEqualTo(msg.length());
            for (int i = 0; i < msg.length(); ++i) {
                Assertions.assertThat((char)msgQueued.charAt(i)).isEqualTo(msg.charAt(i));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

