/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.utils;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.protocols.pop3.mailbox.ImapMailbox;
import org.apache.james.protocols.pop3.mailbox.ImapMessageMetaData;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class MockMailbox
extends ImapMailbox {
    private final Map<Long, Message> messages = new HashMap<Long, Message>();
    private final String identifier;

    public MockMailbox(String identifier, Message ... messages) {
        this.identifier = identifier;
        for (Message m : messages) {
            this.messages.put(Long.parseLong(m.meta.getUid()), m);
        }
    }

    public MockMailbox(String identifier) {
        this(identifier, new Message[0]);
    }

    public InputStream getMessageBody(long uid) {
        Message m = this.messages.get(uid);
        if (m == null) {
            return null;
        }
        return new ByteArrayInputStream(m.body.getBytes(StandardCharsets.US_ASCII));
    }

    public InputStream getMessageHeaders(long uid) {
        Message m = this.messages.get(uid);
        if (m == null) {
            return null;
        }
        return new ByteArrayInputStream((m.headers + "\r\n").getBytes(StandardCharsets.US_ASCII));
    }

    public InputStream getMessage(long uid) throws IOException {
        InputStream body = this.getMessageBody(uid);
        InputStream headers = this.getMessageHeaders(uid);
        if (body == null || headers == null) {
            throw new IOException("Message does not exist for uid " + uid);
        }
        return new SequenceInputStream(headers, body);
    }

    public List<MessageMetaData> getMessages() {
        return (List)this.messages.values().stream().map(m -> m.meta).collect(ImmutableList.toImmutableList());
    }

    public void remove(long ... uids) {
        for (long uid : uids) {
            this.messages.remove(uid);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void close() {
    }

    public static final class Message {
        private static final AtomicLong UIDS = new AtomicLong(0L);
        public final String headers;
        public final String body;
        public final MessageMetaData meta;

        public Message(String headers, String body) {
            this.headers = headers;
            this.body = body;
            this.meta = new ImapMessageMetaData(Long.valueOf(UIDS.incrementAndGet()), (long)(headers.length() + body.length() + 2));
        }

        public String toString() {
            return this.headers + "\r\n" + this.body;
        }
    }
}

