/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.netty;

import java.net.InetSocketAddress;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.netty.NettyServer;
import org.apache.james.protocols.pop3.AbstractPOP3ServerTest;
import org.jboss.netty.util.HashedWheelTimer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class NettyPOP3ServerTest
extends AbstractPOP3ServerTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int RANDOM_PORT = 0;
    private HashedWheelTimer hashedWheelTimer;

    @BeforeEach
    public void setup() {
        this.hashedWheelTimer = new HashedWheelTimer();
    }

    @AfterEach
    public void teardown() {
        this.hashedWheelTimer.stop();
    }

    @Override
    protected ProtocolServer createServer(Protocol protocol) {
        NettyServer server = new NettyServer.Factory(this.hashedWheelTimer).protocol(protocol).build();
        server.setListenAddresses(new InetSocketAddress[]{new InetSocketAddress(LOCALHOST_IP, 0)});
        return server;
    }
}

