/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.UidlCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class UidlCmdHandlerTest {
    @Test
    void onCommandHandlesEmptyMailbox() throws Exception {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(Collections.emptyList()));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getIdentifier()).thenReturn((Object)"id");
        Response response = new UidlCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).startsWith((CharSequence)"+OK ");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)".");
    }

    @Test
    void onCommandRetrievesAllUids() throws Exception {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(new MessageMetaData("123", 123L), new MessageMetaData("456", 456L))));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getIdentifier()).thenReturn((Object)"id");
        Response response = new UidlCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).startsWith((CharSequence)"+OK ");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)"1 123");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(2))).isEqualTo((Object)"2 456");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(3))).isEqualTo((Object)".");
    }

    @Test
    void onCommandExcludesDeletedUids() throws Exception {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(new MessageMetaData("123", 123L), new MessageMetaData("456", 456L))));
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of("123")));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getIdentifier()).thenReturn((Object)"id");
        Response response = new UidlCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(3);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).startsWith((CharSequence)"+OK ");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)"2 456");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(2))).isEqualTo((Object)".");
    }

    @Test
    void onCommandRetrievesSingleUid() throws Exception {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(new MessageMetaData("1234", 567L))));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getIdentifier()).thenReturn((Object)"id");
        Response response = new UidlCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((List)response.getLines()).containsOnly((Object[])new CharSequence[]{"+OK 1 1234"});
    }
}

