/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.TopCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TopCmdHandlerTest {
    @Test
    void onCommandShowsSpecificSyntaxError() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Response response = new TopCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).isEqualTo((Object)"-ERR Usage: TOP [mail number] [line count]");
    }

    @Test
    void onCommandDetectsMissingLinesNumber() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Response response = new TopCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"Usage:"});
    }

    @Test
    void onCommandHandlesMissingContent() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1 2");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenThrow(new Throwable[]{new IOException("cannot retrieve message content")});
        Response response = new TopCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"does not exist"});
    }

    @Test
    void onCommandRetrievesMessageLines() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1 2");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        String message = "Subject: test\r\n\r\nline1\r\nline2\r\nline3\r\n";
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenReturn((Object)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        Response response = new TopCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3StreamResponse.class);
        String result = IOUtils.toString((InputStream)((POP3StreamResponse)response).getStream(), (Charset)StandardCharsets.UTF_8);
        Assertions.assertThat((String)result).contains(new CharSequence[]{"line1"});
        Assertions.assertThat((String)result).contains(new CharSequence[]{"line2"});
        Assertions.assertThat((String)result).doesNotContain(new CharSequence[]{"line3"});
    }
}

