/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.RetrCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RetrCmdHandlerTest {
    RetrCmdHandlerTest() {
    }

    @Test
    void onCommandHandlesMissingContent() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenThrow(new Throwable[]{new IOException("cannot retrieve message content")});
        Response response = new RetrCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"does not exist"});
    }

    @Test
    void onCommandRetrievesMessage() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenReturn((Object)InputStream.nullInputStream());
        Response response = new RetrCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3StreamResponse.class);
    }
}

