/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.apache.james.protocols.pop3.core.POP3MessageCommandDelegate;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class POP3MessageCommandDelegateTest {
    private static final Response SUCCESS = new POP3Response("+OK", (CharSequence)"test succeeded");
    private static final MessageMetaData MESSAGE_META_DATA = new MessageMetaData("1234", 567L);
    private POP3MessageCommandDelegate commandDelegate = new POP3MessageCommandDelegate(Set.of("TEST")){

        protected Response handleMessageExists(POP3Session session, MessageMetaData data, POP3MessageCommandArguments args) throws IOException {
            return SUCCESS;
        }
    };

    @Test
    void onCommandIncludesKeywordInSyntaxError() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Response response = this.commandDelegate.handleMessageRequest(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).isEqualTo((Object)"-ERR Usage: TEST [mail number]");
    }

    @Test
    void onCommandFailsInAuthReadyState() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)0);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Assertions.assertThat((String)this.commandDelegate.handleMessageRequest(session, request).getRetCode()).isEqualTo("-ERR");
    }

    @Test
    void onCommandFailsInUserSetState() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)1);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Assertions.assertThat((String)this.commandDelegate.handleMessageRequest(session, request).getRetCode()).isEqualTo("-ERR");
    }

    @Test
    void onCommandHandlesNonExistingMessage() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Response response = this.commandDelegate.handleMessageRequest(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"does not exist"});
    }

    @Test
    void onCommandHandlesDeletedMessage() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = MESSAGE_META_DATA;
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data.getUid())));
        Response response = this.commandDelegate.handleMessageRequest(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"already deleted"});
    }

    @Test
    void onCommandHandlesExistingMessage() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(MESSAGE_META_DATA)));
        Response response = this.commandDelegate.handleMessageRequest(session, request);
        Assertions.assertThat((Object)response).isEqualTo((Object)SUCCESS);
    }
}

