/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.pop3.core.POP3MessageCommandArguments;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class POP3MessageCommandArgumentsTest {
    @ParameterizedTest
    @ValueSource(ints={8, 16, 32, 64, 128, 256})
    void fromRequestShouldNotThrowOnHexNumberOverflow(int pad) {
        Request request = (Request)Mockito.mock(Request.class);
        String overflowedNumber = Collections.nCopies(pad, "\\xff").stream().collect(Collectors.joining());
        Mockito.when((Object)request.getArgument()).thenReturn((Object)overflowedNumber);
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isEmpty();
    }

    @Test
    void fromRequestShouldNotThrowOnMessageDecNumberOverflow() {
        Request request = (Request)Mockito.mock(Request.class);
        String overflowedNumber = Long.toString(Long.MAX_VALUE);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)overflowedNumber);
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isEmpty();
    }

    @Test
    void fromRequestShouldNotThrowOnNullArgument() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isEmpty();
    }

    @Test
    void fromRequestShouldNotThrowOnInvalidMessageNumber() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"not-a-number");
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isEmpty();
    }

    @Test
    void fromRequestHandlesSingleArgument() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isPresent();
        Assertions.assertThat((int)((POP3MessageCommandArguments)args.get()).getMessageNumber()).isEqualTo(1);
        Assertions.assertThat((boolean)((POP3MessageCommandArguments)args.get()).getLineCount().isPresent()).isFalse();
    }

    @Test
    void fromRequestHandlesTwoArguments() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1 2");
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isPresent();
        Assertions.assertThat((int)((POP3MessageCommandArguments)args.get()).getMessageNumber()).isEqualTo(1);
        Assertions.assertThat((boolean)((POP3MessageCommandArguments)args.get()).getLineCount().isPresent()).isTrue();
        Assertions.assertThat((Integer)((Integer)((POP3MessageCommandArguments)args.get()).getLineCount().get())).isEqualTo(2);
    }

    @Test
    void fromRequestReqjectsMultipleArguments() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1 2 3");
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isEmpty();
    }

    @Test
    void fromRequestHandlesExtraWhiteSpaceInArgument() {
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"    1    2    ");
        Optional args = POP3MessageCommandArguments.fromRequest((Request)request);
        Assertions.assertThat((Optional)args).isPresent();
        Assertions.assertThat((int)((POP3MessageCommandArguments)args.get()).getMessageNumber()).isEqualTo(1);
        Assertions.assertThat((boolean)((POP3MessageCommandArguments)args.get()).getLineCount().isPresent()).isTrue();
        Assertions.assertThat((Integer)((Integer)((POP3MessageCommandArguments)args.get()).getLineCount().get())).isEqualTo(2);
    }
}

