/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.ListCmdHandler;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ListCmdHandlerTest {
    @Test
    void onCommandHandlesEmptyMailbox() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(Collections.emptyList()));
        Response response = new ListCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(2);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).isEqualTo((Object)"+OK 0 0");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)".");
    }

    @Test
    void onCommandRetrievesAllMessages() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(new MessageMetaData("123", 123L), new MessageMetaData("456", 456L))));
        Response response = new ListCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).isEqualTo((Object)"+OK 2 579");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)"1 123");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(2))).isEqualTo((Object)"2 456");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(3))).isEqualTo((Object)".");
    }

    @Test
    void onCommandExcludesDeletedMessages() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn(null);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(new MessageMetaData("123", 123L), new MessageMetaData("456", 456L), new MessageMetaData("789", 789L))));
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of("456")));
        Response response = new ListCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((Object)response).isInstanceOf(POP3Response.class);
        List result = response.getLines();
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((CharSequence)((CharSequence)result.get(0))).isEqualTo((Object)"+OK 2 912");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(1))).isEqualTo((Object)"1 123");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(2))).isEqualTo((Object)"3 789");
        Assertions.assertThat((CharSequence)((CharSequence)result.get(3))).isEqualTo((Object)".");
    }

    @Test
    void onCommandListsSingleMessage() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Response response = new ListCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((List)response.getLines()).containsOnly((Object[])new CharSequence[]{"+OK 1 567"});
    }
}

