/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.protocols.pop3.core.AbstractInputStreamTest;
import org.apache.james.protocols.pop3.core.ExtraDotInputStream;
import org.junit.jupiter.api.Test;

public class ExtraDotInputStreamTest
extends AbstractInputStreamTest {
    @Test
    void testExtraDot() throws IOException {
        String data = "This\r\n.\r\nThis.\r\n";
        String expectedOutput = "This\r\n..\r\nThis.\r\n";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expectedOutput);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expectedOutput);
    }

    @Test
    void testExtraDotOnDoubleDot() throws IOException {
        String data = "This\r\n..\r\nThis.\r\n";
        String expectedOutput = "This\r\n...\r\nThis.\r\n";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expectedOutput);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expectedOutput);
    }

    @Test
    void testExtraDotOnDotWithText() throws IOException {
        String data = "This\r\n.TestText\r\nThis.\r\n";
        String expected = "This\r\n..TestText\r\nThis.\r\n";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
    }

    @Test
    void testNoDotCLRF() throws IOException {
        String data = "ABCD\r\n";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
    }

    @Test
    void testNoDot() throws IOException {
        String data = "ABCD";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
    }

    @Test
    void testNoDotHeaderBody() throws IOException {
        String data = "Subject: test\r\n\r\nABCD\r\n";
        this.checkRead((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
        this.checkReadViaArray((InputStream)new ExtraDotInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
    }
}

