/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.DeleCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DeleCmdHandlerTest {
    @Test
    void onCommandDeletesInitialMessage() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.empty());
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenThrow(new Throwable[]{new IOException("cannot retrieve message content")});
        Response response = new DeleCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"Message deleted"});
        ((POP3Session)Mockito.verify((Object)session)).setAttachment((ProtocolSession.AttachmentKey)ArgumentMatchers.eq((Object)POP3Session.DELETED_UID_LIST), (Object)((List)ArgumentMatchers.argThat(uidList -> uidList.size() == 1 && uidList.contains("1234"))), (ProtocolSession.State)ArgumentMatchers.eq((Object)ProtocolSession.State.Transaction));
    }

    @Test
    void onCommandDeletesAdditionalMessage() throws IOException {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        ArrayList uidList = new ArrayList();
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(uidList));
        Mailbox mailbox = (Mailbox)Mockito.mock(Mailbox.class);
        Mockito.when((Object)session.getUserMailbox()).thenReturn((Object)mailbox);
        Mockito.when((Object)mailbox.getMessage(data.getUid())).thenThrow(new Throwable[]{new IOException("cannot retrieve message content")});
        Response response = new DeleCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("+OK");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"Message deleted"});
        Assertions.assertThat(uidList).containsOnly((Object[])new String[]{"1234"});
        ((POP3Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).setAttachment((ProtocolSession.AttachmentKey)ArgumentMatchers.eq((Object)POP3Session.DELETED_UID_LIST), (Object)ArgumentMatchers.anyList(), (ProtocolSession.State)ArgumentMatchers.eq((Object)ProtocolSession.State.Transaction));
    }

    @Test
    void onCommandHandlesDeletedMessage() {
        POP3Session session = (POP3Session)Mockito.mock(POP3Session.class);
        Mockito.when((Object)session.getHandlerState()).thenReturn((Object)2);
        Request request = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)request.getArgument()).thenReturn((Object)"1");
        MessageMetaData data = new MessageMetaData("1234", 567L);
        Mockito.when((Object)session.getAttachment(POP3Session.UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data)));
        Mockito.when((Object)session.getAttachment(POP3Session.DELETED_UID_LIST, ProtocolSession.State.Transaction)).thenReturn(Optional.of(List.of(data.getUid())));
        Response response = new DeleCmdHandler((MetricFactory)new RecordingMetricFactory()).onCommand(session, request);
        Assertions.assertThat((String)response.getRetCode()).isEqualTo("-ERR");
        Assertions.assertThat((CharSequence)((CharSequence)response.getLines().get(0))).contains(new CharSequence[]{"already deleted"});
    }
}

