/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.protocols.pop3.core.AbstractInputStreamTest;
import org.apache.james.protocols.pop3.core.CRLFTerminatedInputStream;
import org.junit.jupiter.api.Test;

class CRLFTerminatedInputStreamTest
extends AbstractInputStreamTest {
    CRLFTerminatedInputStreamTest() {
    }

    @Test
    void testCRLFPresent() throws IOException {
        String data = "Subject: test\r\n\r\ndata\r\n";
        this.checkRead((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
        this.checkReadViaArray((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), data);
    }

    @Test
    void testCRPresent() throws IOException {
        String data = "Subject: test\r\n\r\ndata\r";
        String expected = data + "\n";
        this.checkRead((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
        this.checkReadViaArray((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
    }

    @Test
    void testLFPresent() throws IOException {
        String data = "Subject: test\r\n\r\ndata\n";
        String expected = "Subject: test\r\n\r\ndata\n\r\n";
        this.checkRead((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
        this.checkReadViaArray((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
    }

    @Test
    void testNonPresent() throws IOException {
        String data = "Subject: test\r\n\r\ndata";
        String expected = data + "\r\n";
        this.checkRead((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
        this.checkReadViaArray((InputStream)new CRLFTerminatedInputStream((InputStream)new ByteArrayInputStream(data.getBytes())), expected);
    }
}

