/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3;

import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import org.apache.commons.net.pop3.POP3SClient;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.utils.BogusSslContextFactory;
import org.apache.james.protocols.api.utils.BogusTrustManagerFactory;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.pop3.POP3Configuration;
import org.apache.james.protocols.pop3.POP3Protocol;
import org.apache.james.protocols.pop3.POP3ProtocolHandlerChain;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.utils.MockMailbox;
import org.apache.james.protocols.pop3.utils.TestPassCmdHandler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractStartTlsPOP3ServerTest {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int RANDOM_PORT = 0;

    private POP3Protocol createProtocol(AbstractPassCmdHandler handler) throws WiringException {
        return new POP3Protocol((ProtocolHandlerChain)new POP3ProtocolHandlerChain(handler), (ProtocolConfiguration)new POP3Configuration());
    }

    protected POP3SClient createClient() {
        POP3SClient client = new POP3SClient(false, BogusSslContextFactory.getClientContext());
        client.setTrustManager(BogusTrustManagerFactory.getTrustManagers()[0]);
        return client;
    }

    protected abstract ProtocolServer createServer(Protocol var1, InetSocketAddress var2, Encryption var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartTls() throws Exception {
        InetSocketAddress address = new InetSocketAddress(LOCALHOST_IP, 0);
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler handler = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            handler.add("valid", (Mailbox)new MockMailbox(identifier));
            server = this.createServer((Protocol)this.createProtocol(handler), address, Encryption.createStartTls((SSLContext)BogusSslContextFactory.getServerContext()));
            server.bind();
            POP3SClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((int)client.sendCommand("CAPA")).isEqualTo(0);
            client.getAdditionalReply();
            boolean startTlsCapa = Arrays.stream(client.getReplyStrings()).anyMatch(cap -> cap.equalsIgnoreCase("STLS"));
            Assertions.assertThat((boolean)startTlsCapa).isTrue();
            Assertions.assertThat((boolean)client.execTLS()).isTrue();
            client.disconnect();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }
}

