/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.james.core.Username;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.pop3.POP3Configuration;
import org.apache.james.protocols.pop3.POP3Protocol;
import org.apache.james.protocols.pop3.POP3ProtocolHandlerChain;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractApopCmdHandler;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.protocols.pop3.utils.MockMailbox;
import org.apache.james.protocols.pop3.utils.TestPassCmdHandler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractPOP3ServerTest {
    private static final MockMailbox.Message MESSAGE1 = new MockMailbox.Message("Subject: test\r\nX-Header: value\r\n", "My Body\r\n");
    private static final MockMailbox.Message MESSAGE2 = new MockMailbox.Message("Subject: test2\r\nX-Header: value2\r\n", "My Body with a DOT.\r\n.\r\n");

    private POP3Protocol createProtocol(AbstractPassCmdHandler handler) throws WiringException {
        return new POP3Protocol((ProtocolHandlerChain)new POP3ProtocolHandlerChain(handler), (ProtocolConfiguration)new POP3Configuration());
    }

    protected abstract ProtocolServer createServer(Protocol var1);

    protected POP3Client createClient() {
        return new POP3Client();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAuth() throws Exception {
        ProtocolServer server = null;
        try {
            server = this.createServer((Protocol)this.createProtocol(new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory())));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("invalid", "invalid")).isFalse();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyInbox() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler handler = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            handler.add("valid", (Mailbox)new MockMailbox(identifier));
            server = this.createServer((Protocol)this.createProtocol(handler));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            POP3MessageInfo[] info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(0);
            info = client.listUniqueIdentifiers();
            Assertions.assertThat((int)info.length).isEqualTo(0);
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInboxWithMessages() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler handler = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            handler.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(handler));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            POP3MessageInfo[] info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(2);
            Assertions.assertThat((int)info[0].size).isEqualTo((int)AbstractPOP3ServerTest.MESSAGE1.meta.getSize());
            Assertions.assertThat((int)info[1].size).isEqualTo((int)AbstractPOP3ServerTest.MESSAGE2.meta.getSize());
            Assertions.assertThat((int)info[0].number).isEqualTo(1);
            Assertions.assertThat((int)info[1].number).isEqualTo(2);
            POP3MessageInfo mInfo = client.listMessage(1);
            Assertions.assertThat((int)mInfo.size).isEqualTo((int)AbstractPOP3ServerTest.MESSAGE1.meta.getSize());
            Assertions.assertThat((int)mInfo.number).isEqualTo(1);
            mInfo = client.listMessage(10);
            Assertions.assertThat((Object)mInfo).isNull();
            info = client.listUniqueIdentifiers();
            Assertions.assertThat((int)info.length).isEqualTo(2);
            Assertions.assertThat((String)info[0].identifier).isEqualTo(identifier + "-" + AbstractPOP3ServerTest.MESSAGE1.meta.getUid());
            Assertions.assertThat((String)info[1].identifier).isEqualTo(identifier + "-" + AbstractPOP3ServerTest.MESSAGE2.meta.getUid());
            Assertions.assertThat((int)info[0].number).isEqualTo(1);
            Assertions.assertThat((int)info[1].number).isEqualTo(2);
            mInfo = client.listUniqueIdentifier(1);
            Assertions.assertThat((String)mInfo.identifier).isEqualTo(identifier + "-" + AbstractPOP3ServerTest.MESSAGE1.meta.getUid());
            Assertions.assertThat((int)mInfo.number).isEqualTo(1);
            mInfo = client.listUniqueIdentifier(10);
            Assertions.assertThat((Object)mInfo).isNull();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetr() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            Reader reader = client.retrieveMessage(1);
            Assertions.assertThat((Object)reader).isNotNull();
            this.checkMessage(MESSAGE1, reader);
            reader.close();
            reader = client.retrieveMessage(10);
            Assertions.assertThat((Object)reader).isNull();
            Assertions.assertThat((boolean)client.deleteMessage(1)).isTrue();
            reader = client.retrieveMessage(1);
            Assertions.assertThat((Object)reader).isNull();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTop() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            Reader reader = client.retrieveMessageTop(1, 1000);
            Assertions.assertThat((Object)reader).isNotNull();
            this.checkMessage(MESSAGE1, reader);
            reader.close();
            reader = client.retrieveMessageTop(2, 1);
            Assertions.assertThat((Object)reader).isNotNull();
            this.checkMessage(MESSAGE2, reader, 1);
            reader.close();
            reader = client.retrieveMessageTop(10, 100);
            Assertions.assertThat((Object)reader).isNull();
            Assertions.assertThat((boolean)client.deleteMessage(1)).isTrue();
            reader = client.retrieveMessageTop(1, 1000);
            Assertions.assertThat((Object)reader).isNull();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDele() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            POP3MessageInfo[] info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(2);
            Assertions.assertThat((boolean)client.deleteMessage(1)).isTrue();
            info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(1);
            Assertions.assertThat((boolean)client.deleteMessage(1)).isFalse();
            info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(1);
            Assertions.assertThat((boolean)client.deleteMessage(2)).isTrue();
            info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(0);
            Assertions.assertThat((boolean)client.logout()).isTrue();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            info = client.listMessages();
            Assertions.assertThat((int)info.length).isEqualTo(0);
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoop() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            Assertions.assertThat((boolean)client.noop()).isTrue();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRset() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            Assertions.assertThat((int)client.listMessages().length).isEqualTo(1);
            Assertions.assertThat((boolean)client.deleteMessage(1)).isTrue();
            Assertions.assertThat((int)client.listMessages().length).isEqualTo(0);
            Assertions.assertThat((boolean)client.reset()).isTrue();
            Assertions.assertThat((int)client.listMessages().length).isEqualTo(1);
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStat() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            POP3MessageInfo info = client.status();
            Assertions.assertThat((int)info.size).isEqualTo((int)(AbstractPOP3ServerTest.MESSAGE1.meta.getSize() + AbstractPOP3ServerTest.MESSAGE2.meta.getSize()));
            Assertions.assertThat((int)info.number).isEqualTo(2);
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentStates() throws Exception {
        ProtocolServer server = null;
        try {
            String identifier = "id";
            TestPassCmdHandler factory = new TestPassCmdHandler((MetricFactory)new RecordingMetricFactory());
            factory.add("valid", (Mailbox)new MockMailbox(identifier, MESSAGE1, MESSAGE2));
            server = this.createServer((Protocol)this.createProtocol(factory));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((Object[])client.listMessages()).isNull();
            Assertions.assertThat((Object[])client.listUniqueIdentifiers()).isNull();
            Assertions.assertThat((boolean)client.deleteMessage(1)).isFalse();
            Assertions.assertThat((Object)client.retrieveMessage(1)).isNull();
            Assertions.assertThat((Object)client.retrieveMessageTop(1, 10)).isNull();
            Assertions.assertThat((Object)client.status()).isNull();
            Assertions.assertThat((boolean)client.reset()).isFalse();
            client.logout();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assertions.assertThat((boolean)client.login("valid", "valid")).isTrue();
            Assertions.assertThat((Object[])client.listMessages()).isNotNull();
            Assertions.assertThat((Object[])client.listUniqueIdentifiers()).isNotNull();
            Reader reader = client.retrieveMessage(1);
            Assertions.assertThat((Object)reader).isNotNull();
            reader.close();
            Assertions.assertThat((Object)client.status()).isNotNull();
            reader = client.retrieveMessageTop(1, 1);
            Assertions.assertThat((Object)reader).isNotNull();
            reader.close();
            Assertions.assertThat((boolean)client.deleteMessage(1)).isTrue();
            Assertions.assertThat((boolean)client.reset()).isTrue();
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAPop() throws Exception {
        ProtocolServer server = null;
        try {
            TestApopCmdHandler handler = new TestApopCmdHandler((MetricFactory)new RecordingMetricFactory());
            server = this.createServer((Protocol)this.createProtocol((AbstractPassCmdHandler)handler));
            server.bind();
            POP3Client client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            String welcomeMessage = client.getReplyString();
            Assertions.assertThat((String)welcomeMessage.trim()).matches(Pattern.compile("\\+OK \\<-?\\d+\\.\\d+@.+\\> .+"));
            Assertions.assertThat((int)client.sendCommand("APOP invalid invalid")).isEqualTo(1);
            handler.add("valid", (Mailbox)new MockMailbox("id"));
            Assertions.assertThat((int)client.sendCommand("APOP valid valid")).isEqualTo(0);
            Assertions.assertThat((boolean)client.logout()).isTrue();
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    private void checkMessage(MockMailbox.Message message, Reader reader) throws IOException {
        int read = 0;
        int i = -1;
        String content = message.toString();
        while ((i = reader.read()) != -1) {
            Assertions.assertThat((int)i).isEqualTo((int)content.charAt(read++));
        }
        Assertions.assertThat((int)read).isEqualTo(content.length());
    }

    private void checkMessage(MockMailbox.Message message, Reader reader, int lines) throws IOException {
        int read = 0;
        String headers = message.headers + "\r\n";
        while (read < headers.length()) {
            Assertions.assertThat((int)reader.read()).isEqualTo((int)headers.charAt(read++));
        }
        Assertions.assertThat((int)read).isEqualTo(headers.length());
        BufferedReader bufReader = new BufferedReader(reader);
        String line = null;
        int linesRead = 0;
        String[] parts = message.body.split("\r\n");
        while ((line = bufReader.readLine()) != null) {
            Assertions.assertThat((String)line).isEqualTo(parts[linesRead++]);
            if (linesRead != lines) continue;
        }
        Assertions.assertThat((int)linesRead).isEqualTo(lines);
    }

    private final class TestApopCmdHandler
    extends AbstractApopCmdHandler {
        private final Map<String, Mailbox> mailboxes;

        public TestApopCmdHandler(MetricFactory metricFactory) {
            super(metricFactory);
            this.mailboxes = new HashMap<String, Mailbox>();
        }

        public void add(String username, Mailbox mailbox) {
            this.mailboxes.put(username, mailbox);
        }

        protected Mailbox auth(POP3Session session, String apopTimestamp, Username user, String digest) throws Exception {
            return this.mailboxes.get(user.asString());
        }
    }
}

