/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import javax.net.ssl.SSLContext;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.NettyServer;
import org.assertj.core.api.Assertions;
import org.jboss.netty.util.HashedWheelTimer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class NettyServerTest {
    private HashedWheelTimer hashedWheelTimer;

    NettyServerTest() {
    }

    @BeforeEach
    void setup() {
        this.hashedWheelTimer = new HashedWheelTimer();
    }

    @AfterEach
    void teardown() {
        this.hashedWheelTimer.stop();
    }

    @Test
    void protocolShouldThrowWhenProtocolIsNull() {
        Assertions.assertThatThrownBy(() -> new NettyServer.Factory(this.hashedWheelTimer).protocol(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenProtocolIsNotGiven() {
        Assertions.assertThatThrownBy(() -> new NettyServer.Factory(this.hashedWheelTimer).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldWorkWhenProtocolIsGiven() {
        Protocol protocol = (Protocol)Mockito.mock(Protocol.class);
        new NettyServer.Factory(this.hashedWheelTimer).protocol(protocol).build();
    }

    @Test
    void buildShouldWorkWhenEverythingIsGiven() throws Exception {
        Protocol protocol = (Protocol)Mockito.mock(Protocol.class);
        Encryption encryption = Encryption.createStartTls((SSLContext)SSLContext.getDefault());
        ChannelHandlerFactory channelHandlerFactory = (ChannelHandlerFactory)Mockito.mock(ChannelHandlerFactory.class);
        new NettyServer.Factory(this.hashedWheelTimer).protocol(protocol).secure(encryption).frameHandlerFactory(channelHandlerFactory).build();
    }
}

