/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import javax.net.ssl.SSLContext;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.NettyServer;
import org.jboss.netty.util.HashedWheelTimer;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class NettyServerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HashedWheelTimer hashedWheelTimer;

    @Before
    public void setup() {
        this.hashedWheelTimer = new HashedWheelTimer();
    }

    @After
    public void teardown() {
        this.hashedWheelTimer.stop();
    }

    @Test
    public void protocolShouldThrowWhenProtocolIsNull() {
        this.expectedException.expect(NullPointerException.class);
        new NettyServer.Factory(this.hashedWheelTimer).protocol(null);
    }

    @Test
    public void buildShouldThrowWhenProtocolIsNotGiven() {
        this.expectedException.expect(IllegalStateException.class);
        new NettyServer.Factory(this.hashedWheelTimer).build();
    }

    @Test
    public void buildShouldWorkWhenProtocolIsGiven() {
        Protocol protocol = (Protocol)Mockito.mock(Protocol.class);
        new NettyServer.Factory(this.hashedWheelTimer).protocol(protocol).build();
    }

    @Test
    public void buildShouldWorkWhenEverythingIsGiven() throws Exception {
        Protocol protocol = (Protocol)Mockito.mock(Protocol.class);
        Encryption encryption = Encryption.createStartTls((SSLContext)SSLContext.getDefault());
        ChannelHandlerFactory channelHandlerFactory = (ChannelHandlerFactory)Mockito.mock(ChannelHandlerFactory.class);
        new NettyServer.Factory(this.hashedWheelTimer).protocol(protocol).secure(encryption).frameHandlerFactory(channelHandlerFactory).build();
    }
}

