/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.netty.AbstractAsyncServer;
import org.apache.james.protocols.netty.AbstractSSLAwareChannelPipelineFactory;
import org.apache.james.protocols.netty.BasicChannelUpstreamHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.LineDelimiterBasedChannelHandlerFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class NettyServer
extends AbstractAsyncServer {
    protected final Protocol protocol;
    protected final Encryption secure;
    private final ChannelHandlerFactory frameHandlerFactory;
    private ExecutionHandler eHandler;
    private ChannelUpstreamHandler coreHandler;
    private int maxCurConnections;
    private int maxCurConnectionsPerIP;

    public static Builder builder() {
        return new Builder();
    }

    private NettyServer(Protocol protocol, Encryption secure, ChannelHandlerFactory frameHandlerFactory) {
        this.protocol = protocol;
        this.secure = secure;
        this.frameHandlerFactory = frameHandlerFactory;
    }

    protected ExecutionHandler createExecutionHandler(int size) {
        return new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(size, 0L, 0L));
    }

    public void setUseExecutionHandler(boolean useHandler, int size) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        if (useHandler) {
            this.eHandler = this.createExecutionHandler(size);
        } else {
            if (this.eHandler != null) {
                this.eHandler.releaseExternalResources();
            }
            this.eHandler = null;
        }
    }

    public void setMaxConcurrentConnections(int maxCurConnections) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnections = maxCurConnections;
    }

    public void setMaxConcurrentConnectionsPerIP(int maxCurConnectionsPerIP) {
        if (this.isBound()) {
            throw new IllegalStateException("Server running already");
        }
        this.maxCurConnectionsPerIP = maxCurConnectionsPerIP;
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new BasicChannelUpstreamHandler(this.protocol, this.secure);
    }

    @Override
    public synchronized void bind() throws Exception {
        this.coreHandler = this.createCoreHandler();
        super.bind();
    }

    private ChannelHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    @Override
    protected ChannelPipelineFactory createPipelineFactory(ChannelGroup group) {
        return new AbstractSSLAwareChannelPipelineFactory(this.getTimeout(), this.maxCurConnections, this.maxCurConnectionsPerIP, group, this.eHandler, this.getFrameHandlerFactory()){

            @Override
            protected ChannelUpstreamHandler createHandler() {
                return NettyServer.this.coreHandler;
            }

            @Override
            protected boolean isSSLSocket() {
                return this.getSSLContext() != null && NettyServer.this.secure != null && !NettyServer.this.secure.isStartTLS();
            }

            @Override
            protected SSLContext getSSLContext() {
                if (NettyServer.this.secure != null) {
                    return NettyServer.this.secure.getContext();
                }
                return null;
            }
        };
    }

    public static class Builder {
        private Protocol protocol;
        private Optional<Encryption> secure = Optional.absent();
        private Optional<ChannelHandlerFactory> frameHandlerFactory = Optional.absent();

        private Builder() {
        }

        public Builder protocol(Protocol protocol) {
            Preconditions.checkNotNull((Object)protocol, (Object)"'protocol' is mandatory");
            this.protocol = protocol;
            return this;
        }

        public Builder secure(Encryption secure) {
            this.secure = Optional.fromNullable((Object)secure);
            return this;
        }

        public Builder frameHandlerFactory(ChannelHandlerFactory frameHandlerFactory) {
            this.frameHandlerFactory = Optional.fromNullable((Object)frameHandlerFactory);
            return this;
        }

        public NettyServer build() {
            Preconditions.checkState((this.protocol != null ? 1 : 0) != 0, (Object)"'protocol' is mandatory");
            return new NettyServer(this.protocol, (Encryption)this.secure.orNull(), (ChannelHandlerFactory)this.frameHandlerFactory.or((Object)new LineDelimiterBasedChannelHandlerFactory(8192)));
        }
    }
}

