/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.james.protocols.netty.AbstractChannelPipelineFactory;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;

public abstract class AbstractSSLAwareChannelPipelineFactory
extends AbstractChannelPipelineFactory {
    private String[] enabledCipherSuites = null;

    public AbstractSSLAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup group, ExecutionHandler eHandler, ChannelHandlerFactory frameHandlerFactory) {
        super(timeout, maxConnections, maxConnectsPerIp, group, eHandler, frameHandlerFactory);
    }

    public AbstractSSLAwareChannelPipelineFactory(int timeout, int maxConnections, int maxConnectsPerIp, ChannelGroup group, String[] enabledCipherSuites, ExecutionHandler eHandler, ChannelHandlerFactory frameHandlerFactory) {
        this(timeout, maxConnections, maxConnectsPerIp, group, eHandler, frameHandlerFactory);
        if (enabledCipherSuites != null) {
            this.enabledCipherSuites = new String[enabledCipherSuites.length];
            for (int i = 0; i < enabledCipherSuites.length; ++i) {
                this.enabledCipherSuites[i] = new String(enabledCipherSuites[i]);
            }
        }
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = super.getPipeline();
        if (this.isSSLSocket()) {
            SSLEngine engine = this.getSSLContext().createSSLEngine();
            engine.setUseClientMode(false);
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                engine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            pipeline.addFirst("sslHandler", (ChannelHandler)new SslHandler(engine));
        }
        return pipeline;
    }

    protected abstract boolean isSSLSocket();

    protected abstract SSLContext getSSLContext();
}

