/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lmtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.net.smtp.RelayPath;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolServer;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.api.handler.ProtocolHandlerChain;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.api.logger.Logger;
import org.apache.james.protocols.api.utils.MockLogger;
import org.apache.james.protocols.api.utils.ProtocolServerUtils;
import org.apache.james.protocols.lmtp.LMTPClient;
import org.apache.james.protocols.lmtp.LMTPConfigurationImpl;
import org.apache.james.protocols.lmtp.LMTPProtocolHandlerChain;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.AbstractSMTPServerTest;
import org.apache.james.protocols.smtp.MailAddress;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.protocols.smtp.utils.TestMessageHook;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractLMTPServerTest
extends AbstractSMTPServerTest {
    protected Protocol createProtocol(ProtocolHandler ... handlers) throws WiringException {
        LMTPProtocolHandlerChain chain = new LMTPProtocolHandlerChain();
        ArrayList<ProtocolHandler> hList = new ArrayList<ProtocolHandler>();
        for (Object handler : handlers) {
            if (handler instanceof MessageHook) {
                handler = new MessageHookAdapter((MessageHook)handler);
            }
            hList.add((ProtocolHandler)handler);
        }
        chain.addAll(0, hList);
        chain.wireExtensibleHandlers();
        return new SMTPProtocol((ProtocolHandlerChain)chain, (SMTPConfiguration)new LMTPConfigurationImpl(), (Logger)new MockLogger());
    }

    @Ignore(value="LMTP can't handle the queue")
    public void testDeliveryWith4SimultaneousThreads() {
    }

    @Ignore(value="Disable")
    public void testInvalidNoBracketsEnformance() throws Exception {
    }

    @Ignore(value="Disable")
    public void testHeloEnforcement() throws Exception {
    }

    @Ignore(value="Disable")
    public void testHeloEnforcementDisabled() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.helo("localhost");
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.mail("me@sender");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.quit();
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assert.assertFalse((boolean)queued.hasNext());
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRcptWithoutBrackets() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.helo("localhost");
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.setSender("me@sender");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.rcpt("rpct1@domain");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.quit();
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assert.assertFalse((boolean)queued.hasNext());
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEhloNotSupported() throws Exception {
        TestMessageHook hook = new TestMessageHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{hook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.sendCommand("HELO localhost");
            Assert.assertTrue((boolean)SMTPReply.isNegativePermanent((int)client.getReplyCode()));
            client.quit();
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.disconnect();
            Iterator queued = hook.getQueued().iterator();
            Assert.assertFalse((boolean)queued.hasNext());
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeliveryHook() throws Exception {
        TestDeliverHook deliverHook = new TestDeliverHook();
        ProtocolServer server = null;
        try {
            server = this.createServer(this.createProtocol(new ProtocolHandler[]{deliverHook}));
            server.bind();
            SMTPClient client = this.createClient();
            InetSocketAddress bindedAddress = new ProtocolServerUtils(server).retrieveBindedAddress();
            client.connect(bindedAddress.getAddress().getHostAddress(), bindedAddress.getPort());
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.helo("localhost");
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.setSender("me@sender");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.addRecipient("rpct1@domain");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.addRecipient("rpct2@domain");
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            Assert.assertTrue((boolean)client.sendShortMessageData("Subject: Testmessage\r\n\r\nThis is a message\r\n"));
            int[] replies = ((LMTPClient)client).getReplies();
            Assert.assertEquals((String)"Expected two replies", (long)2L, (long)replies.length);
            Assert.assertTrue((boolean)SMTPReply.isNegativePermanent((int)replies[0]));
            Assert.assertTrue((boolean)SMTPReply.isPositiveCompletion((int)replies[1]));
            client.quit();
            Assert.assertTrue((String)("Reply=" + client.getReplyString()), (boolean)SMTPReply.isPositiveCompletion((int)client.getReplyCode()));
            client.disconnect();
            Iterator<MailEnvelope> queued = deliverHook.getDelivered().iterator();
            Assert.assertTrue((boolean)queued.hasNext());
            MailEnvelope env = queued.next();
            AbstractLMTPServerTest.checkEnvelope((MailEnvelope)env, (String)"me@sender", Arrays.asList("rpct1@domain", "rpct2@domain"), (String)"Subject: Testmessage\r\n\r\nThis is a message\r\n");
            Assert.assertFalse((boolean)queued.hasNext());
        }
        finally {
            if (server != null) {
                server.unbind();
            }
        }
    }

    protected SMTPClient createClient() {
        return new LMTPClientImpl();
    }

    private final class TestDeliverHook
    implements DeliverToRecipientHook {
        private final List<MailEnvelope> delivered = new ArrayList<MailEnvelope>();

        private TestDeliverHook() {
        }

        public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
            if ("rpct1@domain".equals(recipient.toString())) {
                return new HookResult(2);
            }
            this.delivered.add(envelope);
            return new HookResult(1);
        }

        public List<MailEnvelope> getDelivered() {
            return this.delivered;
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }

    private final class MessageHookAdapter
    implements DeliverToRecipientHook {
        private final MessageHook hook;
        private HookResult result;

        public MessageHookAdapter(MessageHook hook) {
            this.hook = hook;
        }

        public HookResult deliver(SMTPSession session, MailAddress recipient, MailEnvelope envelope) {
            if (this.result == null) {
                this.result = this.hook.onMessage(session, envelope);
            }
            return this.result;
        }

        public void init(Configuration config) throws ConfigurationException {
        }

        public void destroy() {
        }
    }

    private final class LMTPClientImpl
    extends SMTPClient
    implements LMTPClient {
        private final List<Integer> replies = new ArrayList<Integer>();
        private int rcptCount = 0;

        private LMTPClientImpl() {
        }

        public boolean addRecipient(String address) throws IOException {
            boolean ok = super.addRecipient(address);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public boolean addRecipient(RelayPath path) throws IOException {
            boolean ok = super.addRecipient(path);
            if (ok) {
                ++this.rcptCount;
            }
            return ok;
        }

        public int helo(String hostname) throws IOException {
            return this.sendCommand("LHLO", hostname);
        }

        @Override
        public int[] getReplies() throws IOException {
            int[] codes = new int[this.replies.size()];
            for (int i = 0; i < codes.length; ++i) {
                codes[i] = this.replies.remove(0);
            }
            return codes;
        }

        public boolean completePendingCommand() throws IOException {
            for (int i = 0; i < this.rcptCount; ++i) {
                this.replies.add(this.getReply());
            }
            for (int code : this.replies) {
                if (!SMTPReply.isPositiveCompletion((int)code)) continue;
                return true;
            }
            return false;
        }
    }
}

