/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.UidMsnConverter;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedMailboxImpl
implements SelectedMailbox,
MailboxListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectedMailboxImpl.class);
    private final Set<MessageUid> recentUids = new TreeSet<MessageUid>();
    private boolean recentUidRemoved = false;
    private final MailboxManager mailboxManager;
    private MailboxPath path;
    private final ImapSession session;
    private final long sessionId;
    private final Set<MessageUid> flagUpdateUids = new TreeSet<MessageUid>();
    private final Flags.Flag uninterestingFlag = Flags.Flag.RECENT;
    private final Set<MessageUid> expungedUids = new TreeSet<MessageUid>();
    private final UidMsnConverter uidMsnConverter;
    private boolean isDeletedByOtherSession = false;
    private boolean sizeChanged = false;
    private boolean silentFlagChanges = false;
    private final Flags applicableFlags;
    private boolean applicableFlagsChanged;

    public SelectedMailboxImpl(MailboxManager mailboxManager, ImapSession session, MailboxPath path) throws MailboxException {
        this.session = session;
        this.sessionId = ImapSessionUtils.getMailboxSession(session).getSessionId();
        this.mailboxManager = mailboxManager;
        this.setSilentFlagChanges(true);
        this.path = path;
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        this.uidMsnConverter = new UidMsnConverter();
        mailboxManager.addListener(path, (MailboxListener)this, mailboxSession);
        MessageManager messageManager = mailboxManager.getMailbox(path, mailboxSession);
        this.applicableFlags = messageManager.getApplicableFlags(mailboxSession);
        this.uidMsnConverter.addAll((List<MessageUid>)ImmutableList.copyOf((Iterator)messageManager.search(new SearchQuery(new SearchQuery.Criterion[]{SearchQuery.all()}), mailboxSession)));
    }

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.MAILBOX;
    }

    @Override
    public synchronized Optional<MessageUid> getFirstUid() {
        return this.uidMsnConverter.getFirstUid();
    }

    @Override
    public synchronized Optional<MessageUid> getLastUid() {
        return this.uidMsnConverter.getLastUid();
    }

    @Override
    public synchronized void deselect() {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(this.session);
        try {
            this.mailboxManager.removeListener(this.path, (MailboxListener)this, mailboxSession);
        }
        catch (MailboxException e) {
            LOGGER.error("Unable to remove listener {} from mailbox while closing it", (Object)this, (Object)e);
        }
        this.uidMsnConverter.clear();
        this.flagUpdateUids.clear();
        this.expungedUids.clear();
        this.recentUids.clear();
    }

    @Override
    public synchronized boolean removeRecent(MessageUid uid) {
        boolean result = this.recentUids.remove(uid);
        if (result) {
            this.recentUidRemoved = true;
        }
        return result;
    }

    @Override
    public synchronized boolean addRecent(MessageUid uid) {
        return this.recentUids.add(uid);
    }

    @Override
    public synchronized Collection<MessageUid> getRecent() {
        this.checkExpungedRecents();
        return new ArrayList<MessageUid>(this.recentUids);
    }

    @Override
    public synchronized int recentCount() {
        this.checkExpungedRecents();
        return this.recentUids.size();
    }

    @Override
    public synchronized MailboxPath getPath() {
        return this.path;
    }

    private void checkExpungedRecents() {
        for (MessageUid uid : this.expungedUids()) {
            this.removeRecent(uid);
        }
    }

    @Override
    public synchronized boolean isRecent(MessageUid uid) {
        return this.recentUids.contains(uid);
    }

    @Override
    public synchronized boolean isRecentUidRemoved() {
        return this.recentUidRemoved;
    }

    @Override
    public synchronized void resetRecentUidRemoved() {
        this.recentUidRemoved = false;
    }

    @Override
    public synchronized void resetEvents() {
        this.sizeChanged = false;
        this.flagUpdateUids.clear();
        this.isDeletedByOtherSession = false;
        this.applicableFlagsChanged = false;
    }

    @Override
    public synchronized int remove(MessageUid uid) {
        int result = this.msn(uid);
        this.uidMsnConverter.remove(uid);
        return result;
    }

    private boolean interestingFlags(UpdatedFlags updated) {
        Flags.Flag flag;
        Iterator it = updated.systemFlagIterator();
        boolean result = it.hasNext() ? !(flag = (Flags.Flag)it.next()).equals(this.uninterestingFlag) : false;
        if (!result) {
            Iterator userIt = updated.userFlagIterator();
            result = userIt.hasNext();
        }
        return result;
    }

    @Override
    public synchronized void resetExpungedUids() {
        this.expungedUids.clear();
    }

    public final synchronized boolean isSilentFlagChanges() {
        return this.silentFlagChanges;
    }

    public final synchronized void setSilentFlagChanges(boolean silentFlagChanges) {
        this.silentFlagChanges = silentFlagChanges;
    }

    @Override
    public final synchronized boolean isSizeChanged() {
        return this.sizeChanged;
    }

    @Override
    public final synchronized boolean isDeletedByOtherSession() {
        return this.isDeletedByOtherSession;
    }

    @Override
    public synchronized Collection<MessageUid> flagUpdateUids() {
        return Collections.unmodifiableSet(new TreeSet<MessageUid>(this.flagUpdateUids));
    }

    @Override
    public synchronized Collection<MessageUid> expungedUids() {
        return Collections.unmodifiableSet(new TreeSet<MessageUid>(this.expungedUids));
    }

    @Override
    public synchronized Flags getApplicableFlags() {
        return new Flags(this.applicableFlags);
    }

    @Override
    public synchronized boolean hasNewApplicableFlags() {
        return this.applicableFlagsChanged;
    }

    @Override
    public synchronized void resetNewApplicableFlags() {
        this.applicableFlagsChanged = false;
    }

    public synchronized void event(Event event) {
        if (event instanceof MailboxListener.MailboxEvent) {
            MailboxListener.MailboxEvent mailboxEvent = (MailboxListener.MailboxEvent)event;
            this.mailboxEvent(mailboxEvent);
        }
    }

    private void mailboxEvent(MailboxListener.MailboxEvent mailboxEvent) {
        if (mailboxEvent.getMailboxPath().equals((Object)this.getPath())) {
            long eventSessionId = mailboxEvent.getSession().getSessionId();
            if (mailboxEvent instanceof MailboxListener.MessageEvent) {
                MailboxListener.MessageEvent messageEvent = (MailboxListener.MessageEvent)mailboxEvent;
                if (messageEvent instanceof MailboxListener.Added) {
                    this.sizeChanged = true;
                    List uids = ((MailboxListener.Added)mailboxEvent).getUids();
                    SelectedMailbox sm = this.session.getSelected();
                    for (MessageUid uid : uids) {
                        this.uidMsnConverter.addUid(uid);
                        if (sm == null) continue;
                        sm.addRecent(uid);
                    }
                } else if (messageEvent instanceof MailboxListener.FlagsUpdated) {
                    SelectedMailbox sm;
                    MailboxListener.FlagsUpdated updated = (MailboxListener.FlagsUpdated)messageEvent;
                    List uFlags = updated.getUpdatedFlags();
                    if (this.sessionId != eventSessionId || !this.silentFlagChanges) {
                        for (UpdatedFlags u : uFlags) {
                            if (!this.interestingFlags(u)) continue;
                            this.flagUpdateUids.add(u.getUid());
                        }
                    }
                    if ((sm = this.session.getSelected()) != null) {
                        List uflags = updated.getUpdatedFlags();
                        for (UpdatedFlags u : uflags) {
                            Iterator flags = u.systemFlagIterator();
                            while (flags.hasNext()) {
                                MailboxPath path;
                                if (!Flags.Flag.RECENT.equals(flags.next()) || (path = sm.getPath()) == null || !path.equals((Object)mailboxEvent.getMailboxPath())) continue;
                                sm.addRecent(u.getUid());
                            }
                        }
                    }
                    int size = this.applicableFlags.getUserFlags().length;
                    MailboxListener.FlagsUpdated updatedF = (MailboxListener.FlagsUpdated)messageEvent;
                    List flags = updatedF.getUpdatedFlags();
                    for (UpdatedFlags flag : flags) {
                        this.applicableFlags.add(flag.getNewFlags());
                    }
                    this.applicableFlags.remove(Flags.Flag.RECENT);
                    if (size < this.applicableFlags.getUserFlags().length) {
                        this.applicableFlagsChanged = true;
                    }
                } else if (messageEvent instanceof MailboxListener.Expunged) {
                    this.expungedUids.addAll(messageEvent.getUids());
                }
            } else if (mailboxEvent instanceof MailboxListener.MailboxDeletion) {
                if (eventSessionId != this.sessionId) {
                    this.isDeletedByOtherSession = true;
                }
            } else if (mailboxEvent instanceof MailboxListener.MailboxRenamed) {
                MailboxListener.MailboxRenamed mailboxRenamed = (MailboxListener.MailboxRenamed)mailboxEvent;
                this.path = mailboxRenamed.getNewPath();
            }
        }
    }

    @Override
    public synchronized int msn(MessageUid uid) {
        return this.uidMsnConverter.getMsn(uid).orElse(-1);
    }

    @Override
    public synchronized Optional<MessageUid> uid(int msn) {
        if (msn == -1) {
            return Optional.empty();
        }
        return this.uidMsnConverter.getUid(msn);
    }

    @Override
    public synchronized long existsCount() {
        return this.uidMsnConverter.getNumMessage();
    }
}

