/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.message.request.SelectRequest;
import org.apache.james.imap.processor.AbstractSelectionProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class SelectProcessor
extends AbstractSelectionProcessor<SelectRequest> {
    public SelectProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, MetricFactory metricFactory) {
        super(SelectRequest.class, next, mailboxManager, statusResponseFactory, false, metricFactory);
    }

    @Override
    protected Closeable addContextToMDC(SelectRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"SELECT").addContext("mailbox", (Object)message.getMailboxName()).addContext("condstore", (Object)message.getCondstore()).addContext("knownModseq", (Object)message.getKnownModSeq()).addContext("knownUids", (Object)UidRange.toString(message.getKnownUidSet())).addContext("knownIdRange", (Object)IdRange.toString(message.getKnownSequenceSet())).addContext("lastKnownUidValidity", (Object)message.getLastKnownUidValidity()).addContext("uidSet", (Object)UidRange.toString(message.getUidSet())).build();
    }
}

