/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.request.SearchOperation;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.message.request.SearchRequest;
import org.apache.james.imap.message.response.ESearchResponse;
import org.apache.james.imap.message.response.SearchResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchProcessor
extends AbstractMailboxProcessor<SearchRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchProcessor.class);
    protected static final String SEARCH_MODSEQ = "SEARCH_MODSEQ";
    private static final List<String> CAPS = ImmutableList.of((Object)"WITHIN", (Object)"ESEARCH", (Object)"SEARCHRES");

    public SearchProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SearchRequest.class, next, mailboxManager, factory, metricFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcess(SearchRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        SearchOperation operation = request.getSearchOperation();
        SearchKey searchKey = operation.getSearchKey();
        boolean useUids = request.isUseUids();
        List<SearchResultOption> resultOptions = operation.getResultOptions();
        try {
            ImapResponseMessage response;
            Long highestModSeq;
            MessageManager mailbox = this.getSelectedMailbox(session);
            SearchQuery query = this.toQuery(searchKey, session);
            MailboxSession msession = ImapSessionUtils.getMailboxSession(session);
            Iterator it = mailbox.search(query, msession);
            TreeSet<Long> results = new TreeSet<Long>();
            TreeSet<MessageUid> uids = new TreeSet<MessageUid>();
            while (it.hasNext()) {
                MessageUid uid = (MessageUid)it.next();
                if (useUids) {
                    uids.add(uid);
                    results.add(uid.asLong());
                    continue;
                }
                int msn = session.getSelected().msn(uid);
                Long number = msn;
                if (number == -1L) continue;
                results.add(number);
            }
            if (session.getAttribute(SEARCH_MODSEQ) != null) {
                MessageManager.MetaData metaData = mailbox.getMetaData(false, msession, MessageManager.MetaData.FetchGroup.NO_COUNT);
                highestModSeq = this.findHighestModSeq(msession, mailbox, MessageRange.toRanges(uids), metaData.getHighestModSeq());
                this.condstoreEnablingCommand(session, responder, metaData, true);
            } else {
                highestModSeq = null;
            }
            long[] ids = this.toArray(results);
            if (resultOptions == null || resultOptions.isEmpty()) {
                response = new SearchResponse(ids, highestModSeq);
            } else {
                ArrayList<Long> idList = new ArrayList<Long>(ids.length);
                for (long id : ids) {
                    idList.add(id);
                }
                ArrayList<IdRange> idsAsRanges = new ArrayList<IdRange>();
                for (Long id : idList) {
                    idsAsRanges.add(new IdRange(id));
                }
                IdRange[] idRanges = IdRange.mergeRanges(idsAsRanges).toArray(new IdRange[0]);
                ArrayList<UidRange> uidsAsRanges = new ArrayList<UidRange>();
                for (MessageUid uid : uids) {
                    uidsAsRanges.add(new UidRange(uid));
                }
                UidRange[] uidRanges = UidRange.mergeRanges(uidsAsRanges).toArray(new UidRange[0]);
                boolean esearch = false;
                for (SearchResultOption resultOption : resultOptions) {
                    if (SearchResultOption.SAVE == resultOption) continue;
                    esearch = true;
                    break;
                }
                if (esearch) {
                    long min = -1L;
                    long max = -1L;
                    long count = ids.length;
                    if (ids.length > 0) {
                        min = ids[0];
                        max = ids[ids.length - 1];
                    }
                    if (resultOptions.contains((Object)SearchResultOption.SAVE)) {
                        if (resultOptions.contains((Object)SearchResultOption.ALL) || resultOptions.contains((Object)SearchResultOption.COUNT)) {
                            SearchResUtil.saveSequenceSet(session, idRanges);
                        } else {
                            ArrayList<IdRange> savedRanges = new ArrayList<IdRange>();
                            if (resultOptions.contains((Object)SearchResultOption.MIN)) {
                                savedRanges.add(new IdRange(min));
                            }
                            if (resultOptions.contains((Object)SearchResultOption.MAX)) {
                                savedRanges.add(new IdRange(max));
                            }
                            SearchResUtil.saveSequenceSet(session, savedRanges.toArray(new IdRange[0]));
                        }
                    }
                    response = new ESearchResponse(min, max, count, idRanges, uidRanges, highestModSeq, tag, useUids, resultOptions);
                } else {
                    SearchResUtil.saveSequenceSet(session, idRanges);
                    response = new SearchResponse(ids, highestModSeq);
                }
            }
            responder.respond(response);
            boolean omitExpunged = !useUids;
            this.unsolicitedResponses(session, responder, omitExpunged, useUids);
            this.okComplete(command, tag, responder);
        }
        catch (MessageRangeException e) {
            LOGGER.debug("Search failed in mailbox {} because of an invalid sequence-set ", (Object)session.getSelected().getPath(), (Object)e);
            this.taggedBad(command, tag, responder, HumanReadableText.INVALID_MESSAGESET);
        }
        catch (MailboxException e) {
            LOGGER.error("Search failed in mailbox {}", (Object)session.getSelected().getPath(), (Object)e);
            this.no(command, tag, responder, HumanReadableText.SEARCH_FAILED);
            if (resultOptions.contains((Object)SearchResultOption.SAVE)) {
                SearchResUtil.resetSavedSequenceSet(session);
            }
        }
        finally {
            session.setAttribute(SEARCH_MODSEQ, null);
        }
    }

    private long[] toArray(Collection<Long> results) {
        return results.stream().mapToLong(x -> x).toArray();
    }

    private Long findHighestModSeq(MailboxSession session, MessageManager mailbox, List<MessageRange> ranges, long currentHighest) throws MailboxException {
        Long highestModSeq = null;
        int size = ranges.size();
        for (int i = size - 1; i > 0; --i) {
            MessageResultIterator results = mailbox.getMessages(ranges.get(i), FetchGroupImpl.MINIMAL, session);
            while (results.hasNext()) {
                long modSeq = ((MessageResult)results.next()).getModSeq();
                if (highestModSeq == null || modSeq > highestModSeq) {
                    highestModSeq = modSeq;
                }
                if (highestModSeq != currentHighest) continue;
                return highestModSeq;
            }
        }
        return highestModSeq;
    }

    private SearchQuery toQuery(SearchKey key, ImapSession session) throws MessageRangeException {
        SearchQuery result = new SearchQuery();
        SelectedMailbox selected = session.getSelected();
        if (selected != null) {
            result.addRecentMessageUids(selected.getRecent());
        }
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        result.andCriteria(criterion);
        return result;
    }

    private SearchQuery.Criterion toCriterion(SearchKey key, ImapSession session) throws MessageRangeException {
        int type = key.getType();
        DayMonthYear date = key.getDate();
        switch (type) {
            case 3: {
                return SearchQuery.all();
            }
            case 37: {
                return this.and(key.getKeys(), session);
            }
            case 4: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case 17: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Bcc, (String)key.getValue());
            }
            case 26: {
                return SearchQuery.internalDateBefore((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case 18: {
                return SearchQuery.bodyContains((String)key.getValue());
            }
            case 19: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.Cc, (String)key.getValue());
            }
            case 5: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case 6: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case 7: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case 20: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.From, (String)key.getValue());
            }
            case 32: {
                String value = key.getValue();
                if (value == null || value.length() == 0) {
                    return SearchQuery.headerExists((String)key.getName());
                }
                return SearchQuery.headerContains((String)key.getName(), (String)value);
            }
            case 21: {
                return SearchQuery.flagIsSet((String)key.getValue());
            }
            case 33: {
                return SearchQuery.sizeGreaterThan((long)key.getSize());
            }
            case 8: {
                return SearchQuery.and((SearchQuery.Criterion)SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT), (SearchQuery.Criterion)SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN));
            }
            case 35: {
                return this.not(key.getKeys(), session);
            }
            case 9: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case 27: {
                return SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case 36: {
                return this.or(key.getKeys(), session);
            }
            case 10: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.RECENT);
            }
            case 11: {
                return SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case 28: {
                return SearchQuery.headerDateBefore((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case 29: {
                return SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
            }
            case 30: {
                SearchQuery.Criterion onCrit = SearchQuery.headerDateOn((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                SearchQuery.Criterion afterCrit = SearchQuery.headerDateAfter((String)"Date", (Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day);
                return SearchQuery.or((SearchQuery.Criterion)onCrit, (SearchQuery.Criterion)afterCrit);
            }
            case 1: {
                return this.sequence(key.getSequenceNumbers(), session);
            }
            case 31: {
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)date.toDate(), (SearchQuery.DateResolution)SearchQuery.DateResolution.Day));
            }
            case 34: {
                return SearchQuery.sizeLessThan((long)key.getSize());
            }
            case 22: {
                return SearchQuery.headerContains((String)"Subject", (String)key.getValue());
            }
            case 23: {
                return SearchQuery.mailContains((String)key.getValue());
            }
            case 24: {
                return SearchQuery.address((SearchQuery.AddressType)SearchQuery.AddressType.To, (String)key.getValue());
            }
            case 2: {
                return this.uids(key.getUidRanges(), session);
            }
            case 12: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.ANSWERED);
            }
            case 13: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DELETED);
            }
            case 14: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.DRAFT);
            }
            case 15: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.FLAGGED);
            }
            case 25: {
                return SearchQuery.flagIsUnSet((String)key.getValue());
            }
            case 16: {
                return SearchQuery.flagIsUnSet((Flags.Flag)Flags.Flag.SEEN);
            }
            case 39: {
                Date withinDate = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateBefore((Date)withinDate, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case 38: {
                Date withinDate2 = this.createWithinDate(key);
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.internalDateOn((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second), (SearchQuery.Criterion)SearchQuery.internalDateAfter((Date)withinDate2, (SearchQuery.DateResolution)SearchQuery.DateResolution.Second));
            }
            case 40: {
                session.setAttribute(SEARCH_MODSEQ, true);
                long modSeq = key.getModSeq();
                return SearchQuery.or((SearchQuery.Criterion)SearchQuery.modSeqEquals((long)modSeq), (SearchQuery.Criterion)SearchQuery.modSeqGreaterThan((long)modSeq));
            }
        }
        LOGGER.warn("Ignoring unknown search key {}", (Object)type);
        return SearchQuery.all();
    }

    private Date createWithinDate(SearchKey key) {
        long seconds = key.getSeconds();
        long res = System.currentTimeMillis() - seconds * 1000L;
        return new Date(res);
    }

    private SearchQuery.Criterion sequence(IdRange[] sequenceNumbers, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (IdRange range : sequenceNumbers) {
                long lowVal = range.getLowVal();
                long highVal = range.getHighVal();
                if (lowVal == Long.MAX_VALUE && highVal == Long.MAX_VALUE) {
                    MessageUid highUid = selected.getLastUid().orElse(MessageUid.MIN_VALUE);
                    ranges.add(new SearchQuery.UidRange(highUid));
                    continue;
                }
                Optional<MessageUid> lowUid = lowVal != Long.MIN_VALUE ? selected.uid((int)lowVal) : selected.getFirstUid();
                if (!lowUid.isPresent()) continue;
                Optional<Object> highUid = Optional.empty();
                if (highVal != Long.MAX_VALUE) {
                    highUid = selected.uid((int)highVal);
                    if (!highUid.isPresent()) {
                        highUid = selected.getLastUid();
                    }
                } else {
                    highUid = selected.getLastUid();
                }
                ranges.add(new SearchQuery.UidRange(lowUid.orElse(MessageUid.MIN_VALUE), (MessageUid)highUid.orElse(MessageUid.MAX_VALUE)));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])ranges.toArray(new SearchQuery.UidRange[0]));
    }

    private SearchQuery.Criterion uids(UidRange[] uids, ImapSession session) throws MessageRangeException {
        SelectedMailbox selected = session.getSelected();
        ArrayList<SearchQuery.UidRange> ranges = new ArrayList<SearchQuery.UidRange>();
        if (selected.existsCount() > 0L) {
            for (UidRange range : uids) {
                MessageUid lowVal = range.getLowVal();
                MessageUid highVal = range.getHighVal();
                if (lowVal.equals((Object)MessageUid.MAX_VALUE) && highVal.equals((Object)MessageUid.MAX_VALUE)) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                if (highVal.equals((Object)MessageUid.MAX_VALUE) && selected.getLastUid().orElse(MessageUid.MIN_VALUE).compareTo(lowVal) < 0) {
                    ranges.add(new SearchQuery.UidRange(selected.getLastUid().orElse(MessageUid.MIN_VALUE)));
                    continue;
                }
                ranges.add(new SearchQuery.UidRange(lowVal, highVal));
            }
        }
        return SearchQuery.uid((SearchQuery.UidRange[])ranges.toArray(new SearchQuery.UidRange[0]));
    }

    private SearchQuery.Criterion or(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey keyOne = keys.get(0);
        SearchKey keyTwo = keys.get(1);
        SearchQuery.Criterion criterionOne = this.toCriterion(keyOne, session);
        SearchQuery.Criterion criterionTwo = this.toCriterion(keyTwo, session);
        return SearchQuery.or((SearchQuery.Criterion)criterionOne, (SearchQuery.Criterion)criterionTwo);
    }

    private SearchQuery.Criterion not(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        SearchKey key = keys.get(0);
        SearchQuery.Criterion criterion = this.toCriterion(key, session);
        return SearchQuery.not((SearchQuery.Criterion)criterion);
    }

    private SearchQuery.Criterion and(List<SearchKey> keys, ImapSession session) throws MessageRangeException {
        int size = keys.size();
        ArrayList<SearchQuery.Criterion> criteria = new ArrayList<SearchQuery.Criterion>(size);
        for (SearchKey key : keys) {
            SearchQuery.Criterion criterion = this.toCriterion(key, session);
            criteria.add(criterion);
        }
        return SearchQuery.and(criteria);
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    protected Closeable addContextToMDC(SearchRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"SEARCH").addContext("useUid", (Object)message.isUseUids()).addContext("searchOperation", (Object)message.getSearchOperation()).build();
    }
}

