/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LogoutRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutProcessor
extends AbstractMailboxProcessor<LogoutRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutProcessor.class);

    public LogoutProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(LogoutRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(LogoutRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        try {
            this.getMailboxManager().logout(mailboxSession, false);
            session.logout();
            this.bye(responder);
            this.okComplete(command, tag, responder);
        }
        catch (MailboxException e) {
            LOGGER.error("Logout failed for user {}", (Object)mailboxSession.getUser().getUserName(), (Object)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    protected Closeable addContextToMDC(LogoutRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"LOGOUT").build();
    }
}

