/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.GetQuotaRequest;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class GetQuotaProcessor
extends AbstractMailboxProcessor<GetQuotaRequest>
implements CapabilityImplementingProcessor {
    private static final List<String> CAPABILITIES = ImmutableList.of((Object)"QUOTA");
    private final QuotaManager quotaManager;
    private final QuotaRootResolver quotaRootResolver;

    public GetQuotaProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, QuotaManager quotaManager, QuotaRootResolver quotaRootResolver, MetricFactory metricFactory) {
        super(GetQuotaRequest.class, next, mailboxManager, factory, metricFactory);
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected void doProcess(GetQuotaRequest message, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        try {
            QuotaRoot quotaRoot = this.quotaRootResolver.fromString(message.getQuotaRoot());
            if (this.hasRight(quotaRoot, session)) {
                Quota messageQuota = this.quotaManager.getMessageQuota(quotaRoot);
                Quota storageQuota = this.quotaManager.getStorageQuota(quotaRoot);
                if (((QuotaCount)messageQuota.getLimit()).isLimited()) {
                    responder.respond(new QuotaResponse("MESSAGE", quotaRoot.getValue(), messageQuota));
                }
                if (((QuotaSize)storageQuota.getLimit()).isLimited()) {
                    responder.respond(new QuotaResponse("STORAGE", quotaRoot.getValue(), storageQuota));
                }
                this.okComplete(command, tag, responder);
            } else {
                Object[] params = new Object[]{MailboxACL.Right.Read.toString(), command.getName(), "Any mailbox of this user USER"};
                HumanReadableText humanReadableText = new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", params);
                this.no(command, tag, responder, humanReadableText);
            }
        }
        catch (MailboxException me) {
            this.taggedBad(command, tag, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX);
        }
    }

    private boolean hasRight(QuotaRoot quotaRoot, ImapSession session) throws MailboxException {
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        List mailboxList = this.quotaRootResolver.retrieveAssociatedMailboxes(quotaRoot, mailboxSession);
        for (MailboxPath mailboxPath : mailboxList) {
            if (!this.getMailboxManager().hasRight(mailboxPath, MailboxACL.Right.Read, mailboxSession)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Closeable addContextToMDC(GetQuotaRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"GET_QUOTA").addContext("quotaRoot", (Object)message.getQuotaRoot()).build();
    }
}

