/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.io.Closeable;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.CreateRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateProcessor
extends AbstractMailboxProcessor<CreateRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateProcessor.class);

    public CreateProcessor(ImapProcessor next, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CreateRequest.class, next, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void doProcess(CreateRequest request, ImapSession session, String tag, ImapCommand command, ImapProcessor.Responder responder) {
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(request.getMailboxName());
        try {
            MailboxManager mailboxManager = this.getMailboxManager();
            mailboxManager.createMailbox(mailboxPath, ImapSessionUtils.getMailboxSession(session));
            this.unsolicitedResponses(session, responder, false);
            this.okComplete(command, tag, responder);
        }
        catch (MailboxExistsException e) {
            LOGGER.debug("Create failed for mailbox {} as it already exists", (Object)mailboxPath, (Object)e);
            this.no(command, tag, responder, HumanReadableText.MAILBOX_EXISTS);
        }
        catch (TooLongMailboxNameException e) {
            LOGGER.debug("The mailbox name length is over limit: {}", (Object)mailboxPath.getName(), (Object)e);
            this.taggedBad(command, tag, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
        }
        catch (MailboxException e) {
            LOGGER.error("Create failed for mailbox {}", (Object)mailboxPath, (Object)e);
            this.no(command, tag, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
        }
    }

    @Override
    protected Closeable addContextToMDC(CreateRequest message) {
        return MDCBuilder.create().addContext("action", (Object)"CREATE").addContext("mailbox", (Object)message.getMailboxName()).build();
    }
}

